@extends('layout')
@section('styles')
    <link rel="stylesheet" href="{!! URL::asset('css/admin.css') !!}">
@endsection
@section('content')
    <div class="container top-margin">
        <div class="row">
            <div class="col-md-12">
                <div class="panel panel-primary top-panel-margin">
                    <div class="panel-heading"><span class="fa fa-users"></span> Регистрирани корисници</div>

                    <div class="panel-body">
                        @if(session('status'))
                            <div class="alert {!! session('status-class') !!} alert-dismissable fade in">
                                <a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>
                                {!! session('status') !!}
                            </div>
                        @endif
                        <div class="users">
                            <table class="table">
                                <thead>
                                <th>Име</th>
                                <th>E-mail</th>
                                <th>Корисник</th>
                                <th>Едитор</th>
                                <th>Админ</th>
                                </thead>
                                <tbody>
                                @foreach($users as $user)
                                    <tr {!! $user->id==Auth::id() ? 'class="alert-info"' : '' !!}>
                                        <form action="{!! route('assignRoles') !!}" method="post">
                                            <td>{!! $user->name !!}</td>
                                            <td>{!! $user->email !!}<input type="hidden" name="email" value="{!! $user->email !!}"></td>
                                            <td><input type="checkbox"{!! $user->hasRole('User') ? 'checked' : '' !!} {!! $user->hasRole('User') ? 'checked' : '' !!} name="role_user" {!! $user->id==Auth::id() ? 'disabled="disabled"' : '' !!}></td>
                                            <td><input type="checkbox" {!! $user->hasRole('Editor') ? 'checked' : '' !!} name="role_editor" {!! $user->id==Auth::id() ? 'disabled="disabled"' : '' !!}></td>
                                            <td><input type="checkbox" {!! $user->hasRole('Admin') ? 'checked' : '' !!} name="role_admin" {!! $user->id==Auth::id() ? 'disabled="disabled"' : '' !!}></td>
                                            {!! csrf_field() !!}
                                            <td>
                                                <button class="btn btn-primary" type="submit" {!! $user->id==Auth::id() ? 'disabled="disabled"' : '' !!}>Промени</button>
                                                <a href="#" {!! $user->id==Auth::id() ? 'disabled="disabled"' : '' !!} class="btn btn-danger" data-toggle="modal" data-target="#modal-delete-{!! $user->id !!}"><span class="fa fa-trash-o"></span></a>
                                            </td>
                                        </form>
                                    </tr>
                                    <div class="modal fade" id="modal-delete-{!! $user->id !!}">
                                        <div class="modal-dialog">
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                                                    <h4 class="modal-title">Избриши корисник</h4>
                                                </div>
                                                <div class="modal-body grey-bg">
                                                    <p>
                                                        Дали сте сигурни дека сакате да го избришете корисникот {!! $user->name !!} ?<br>
                                                    </p>
                                                </div>
                                                <div class="modal-footer grey-bg">
                                                    <a href="{!! URL::route('deleteUser', ['id'=>$user->id])!!}" class="btn btn-danger">Избриши&nbsp; <span class="fa fa-trash-o"></span>
                                                    </a>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('scripts')
    <script>
        $('#za_nas').click(function(){
            window.location.href ='{!! route('getHome') !!}#about-us';
        });
    </script>
    @endsection
