@extends('layout')
@section('styles')
    <link rel="stylesheet" href="{!! URL::asset('css/admin.css') !!}">
@endsection
@section('content')
    <div class="container top-margin">
        <div class="row">
            <div class="col-md-12">
                <div class="panel panel-primary top-panel-margin">
                    <div class="panel-heading"><span class="fa fa-camera"></span> Додади албум</div>

                    <div class="panel-body">
                        @if(session('status'))
                            <div class="alert {!! session('status-class') !!} alert-dismissable fade in">
                                <a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>
                                {!! session('status') !!}
                            </div>
                        @endif
                            <div class="col-md-12">
                                <form class="form-horizontal" role="form" method="POST" action="{!! route('createGalleryFirst') !!}" novalidate>
                                    {{ csrf_field() }}
                                    <div class="form-group{{ $errors->has('title') ? ' has-error' : '' }} col-md-12">
                                        <label for="title" class="col-md-12">Наслов</label>
                                        <div class="col-md-12">
                                            <input id="title" type="text" class="form-control" name="title" value="{{ old('title') }}">
                                            @if ($errors->has('title'))
                                                <span class="help-block">
                                                        <strong>{{ $errors->first('title') }}</strong>
                                                    </span>
                                            @endif
                                        </div>
                                    </div>
                                    <div class="form-group{{ $errors->has('description') ? ' has-error' : '' }} col-md-12">
                                        <label for="description" class="col-md-12">Краток опис</label>
                                        <div class="col-md-12">
                                            <textarea id="description" class="form-control" name="description">{{ old('description') }}</textarea>
                                            @if ($errors->has('description'))
                                                <span class="help-block">
                                                        <strong>{{ $errors->first('description') }}</strong>
                                                    </span>
                                            @endif
                                        </div>
                                    </div>
                                    <div class="col-md-12">
                                        <button type="submit" class="btn btn-primary">
                                            ПРОДОЛЖИ
                                             <i class="fa fa-angle-double-right" aria-hidden="true"></i>
                                        </button>
                                    </div>
                                </form>
                            </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('scripts')
    <script>
        $('#za_nas').click(function(){
            window.location.href ='{!! route('getHome') !!}#about-us';
        });
    </script>
    @endsection
