<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Event;
use App\Gallery;
use App\GalleryImage;
use App\Page;
use App\EventCategory;

class HomeController extends Controller
{
    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $event_categories=\DB::table('event_categories')->orderBy('id', 'asc')->get();
        return view('pages.home',['event_categories'=>$event_categories]);
    }

    public function getProducts()
    {
        $event_categories=\DB::table('event_categories')->orderBy('id', 'asc')->get();
        return view('pages.products', ['event_categories'=>$event_categories]);
    }

    public function getProduct($id)
    {
        $event=Event::find($id);
        return view('pages.product', ['event'=>$event]);
    }

    public function getProductCategory($id, $slug)
    {
        $event_category=EventCategory::find($id);
        $events=EventCategory::find($id)->events()->get();
        return view('pages.product_category', ['event_category'=>$event_category, 'events'=>$events]);
    }

    public function getGalleries()
    {
        $galleries=Page::find(1)->galleries()->orderBy('gallery_order', 'asc')->get();

        return view('pages.gallery', ['galleries'=>$galleries]);
    }

    public function getGalleryImages(Request $request, $id)
    {
        $gallery=Gallery::find($id);
        $gallery_images=Gallery::find($id)->gallery_images()->orderBy('image_order', 'asc')->get();

        if ($request->ajax()) {
            return response()
                ->json(view('pages.partials.gallery_images', [
                    'gallery_images'=>$gallery_images,
                    'gallery_id'=>$id,
                    'gallery'=>$gallery
                ])
                    ->render());
        }

        return view('pages.partials.gallery_images', ['gallery_images'=>$gallery_images]);
    }

    public function getContact()
    {
        return view('pages.contact');
    }

    public function sendMessage(Request $request)
    {

        $validator = \Validator::make($request->all(), array(
            'name' => 'required',
            'email' => 'required|email',
            'subject' => 'required',
            'message' => 'required'
        ));

        $name = $_POST['name'];
        $email = $_POST['email'];
        $subject = $_POST['subject'];
        $message = $_POST['message'];

        if ($validator->fails()) {
            $val_messages = $validator->messages();
            $data = array(
                'message_name' => $val_messages->first('name'),
                'message_email' => $val_messages->first('email'),
                'message_subject' => $val_messages->first('subject'),
                'message_message' => $val_messages->first('message'),
                'message' => 'The message can not be sent. Please check your input and try again !',
                'validator' => 'fail_validator'
            );
            return json_encode($data);
        } else {
            \Mail::send('emails.message', ['name' => $name, 'subject' => $subject, 'client_message' => $message, 'email' => $email], function ($message) {
                $message
                    ->to('ohrbiser@mt.net.mk', 'Webmaster')
                    ->replyTo($_POST['email'], $_POST['name'])
                    ->subject($_POST['subject']);
            });

            if (count(\Mail::failures()) > 0) {
                $data = array(
                    'message' => 'The message can not be sent. Please check your input and try again !',
                    'validator' => 'fail_sending'
                );
                return json_encode($data);
            } else {
                $data = array(
                    'message' => 'Message sent ! Our team will answer you as soon as possible',
                    'validator' => 'success'
                );
                return json_encode($data);
            }
        }
    }
}


