<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\User;
use App\Page;
use App\Role;
use App\Event;
use App\Gallery;
use App\Video;
use App\GalleryImage;
use App\EventCategory;
use Illuminate\Support\Facades\Auth;

use Carbon\Carbon;
use Intervention\Image\Facades\Image as Image;
use Illuminate\Support\Facades\Validator;

class DashboardController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    protected $image;

    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Http\Response
     */

    /*
     * User methods
     */
    public function getUsers()
    {
        $users=User::all();
        return view('auth.users', ['users'=>$users]);
    }

    public function assignRoles(Request $request)
    {
        $user=User::where('email', $request['email'])->first();
        $user->roles()->detach();
        if($request['role_user']){
            $user->roles()->attach(Role::where('name', 'User')->first());
        }
        if($request['role_admin']){
            $user->roles()->attach(Role::where('name', 'Admin')->first());
        }
        if($request['role_editor']){
            $user->roles()->attach(Role::where('name', 'Editor')->first());
        }

        return redirect()->route('getUsers')
            ->with('status', 'Промените се успешно зачувани !')
            ->with('status-class', 'alert-success');
    }

    /*
     * Gallery methods
     */
    public function getGallery()
    {
        return view('auth.gallery_first');
    }

    public function getVideo()
    {
        return view('auth.video_first');
    }

    public function getEventAdmin()
    {
        return view('auth.event_first');
    }

    public function getGalleryBack(Request $request)
    {
        if($request->session()->has('gallery_id'))
        {
            \DB::table('galleries')->where('id', session('gallery_id'))->delete();
            \DB::table('gallery_images')->where('gallery_id', session('gallery_id'))->delete();
            \File::deleteDirectory('images/galleries/'.session('gallery_id'));
            $request->session()->forget('gallery_id');
        }

        return view('auth.gallery_first');
    }

    public function getGalleriesAdmin(Request $request)
    {
        if(session('upload_images')=='upload_new_images')
        {
            $request->session()->forget('upload_images');
            $gallery=\DB::table('galleries')->find(session('gallery_id'));
            return view('auth.edit_gallery', ['gallery'=>$gallery]);
        }
        if(session('upload_images')=='create_new_gallery')
        {
            $request->session()->forget('upload_images');
            $galleries=\DB::table('galleries')->orderBy('id', 'desc')->paginate(8);
            return view('auth.galleries_admin', ['galleries'=>$galleries]);
        }
        $galleries=\DB::table('galleries')->orderBy('gallery_order', 'asc')->paginate(8);
        return view('auth.galleries_admin', ['galleries'=>$galleries]);
    }

    public function createGalleryFirst(Request $request)
    {

        $this->validate($request, [
            'title' => 'required|max:75',
            'description' => 'max:150',
        ]);

        $title=$_POST['title'];
        $description=$_POST['description'];

        $gallery=new Gallery();
        $gallery->gallery_name=$title;
        $gallery->gallery_description=$description;
        if($gallery->save())
        {
            session(['gallery_id'=>$gallery->id]);
            session(['upload_images'=>'create_new_gallery']);
            return view('auth.gallery_second');
        }
        return redirect()->route('getGallery')
            ->with('status', 'Обидете се повторно !')
            ->with('status-class', 'alert-danger');

    }

    public function createGallerySecond(Request $request)
    {
        if(\Request::ajax())
        {
            /*stavanje na slikite vo folder so ime id na galerijata */

            $validation=$this->validate($request, [
                'file' => 'mimes:jpeg, jpg:2000',
            ]);
            $file = \Input::file('file');

            $filename = str_random(10).$file->getClientOriginalName();

            $upload_image=$file->move('images/galleries/'.session('gallery_id').'/', $filename);

            if ($upload_image)
            {
                if (!file_exists('images/galleries/'.session('gallery_id').'/thumbnails'))
                {
                    mkdir('images/galleries/'.session('gallery_id').'/thumbnails');
                }
                if(copy('images/galleries/'.session('gallery_id').'/'.$filename, 'images/galleries/'.session('gallery_id').'/thumbnails/'.$filename))
                {
                    $thumb = Image::make('images/galleries/'.session('gallery_id').'/thumbnails/'.$filename)->fit(500);
                    $thumb->save('images/galleries/'.session('gallery_id').'/thumbnails/'.$filename, 85);
                    $insert=\DB::table('gallery_images')->insert([
                        [
                            'image' => $filename,
                            'thumbnail' => 'thumbnails/'.$filename,
                            'image_description'=>null,
                            'image_alt'=>null,
                            'gallery_id'=>session('gallery_id')
                        ],
                    ]);
                    if($insert)
                    {
                        return \Response::json('success', 200);
                    }
                    else
                    {
                        return \Response::json('error', 400);
                    }
                }
                else
                {
                    return \Response::json('error', 400);
                }
            }
            else
            {
                return \Response::json('error', 400);
            }
        }

        return redirect()->route('getGallery')
        ->with('status', 'Активирајте javascript поддршка за да може да креирате галерија !')
        ->with('status-class', 'alert-danger');
    }

    public function getEditGallery(Request $request, $id)
    {
        $gallery=\DB::table('galleries')->find($id);

        return view('auth.edit_gallery', ['gallery'=>$gallery]);
    }

    /*
     * Delete gallery
     */

    public function deleteGallery($id)
    {
        if (\DB::table('gallery_images')->where('gallery_id', $id)->count() > 0)
        {
            \DB::table('gallery_images')->where('gallery_id', $id)->delete();
        }

        if (\DB::table('gallery_page')->where('gallery_id', $id)->count() > 0)
        {
            \DB::table('gallery_page')->where('gallery_id', $id)->delete();
        }

        if (\DB::table('gallery_event')->where('gallery_id', $id)->count() > 0)
        {
            \DB::table('gallery_event')->where('gallery_id', $id)->delete();
        }

        $gallery_delete=\DB::table('galleries')->where('id', $id)->delete();
        if($gallery_delete)
        {
            if(\File::exists('images/galleries/'.$id))
            {
                \File::deleteDirectory('images/galleries/'.$id);
            }
            return redirect()->route('getGalleriesAdmin')
                ->with('status', 'Галеријата е успешно избришана !')
                ->with('status-class', 'alert-success');
        }

        return redirect()->route('getGallery')
            ->with('status', 'Галеријата не може да се избрише !')
            ->with('status-class', 'alert-danger');
    }

    public function deleteGalleryImage($id)
    {
        $image=\DB::table('gallery_images')->find($id);

        if(\File::exists('images/galleries/'.$image->gallery_id."/".$image->image)&&'images/galleries/'.$image->gallery_id."/".$image->thumbnail)
        {
            $image_delete=\File::delete('images/galleries/'.$image->gallery_id."/".$image->image);
            $thumb_delete=\File::delete('images/galleries/'.$image->gallery_id."/".$image->thumbnail);
            if($image_delete&&$thumb_delete)
            {
                if (\DB::table('gallery_images')->where('id', $id)->count() > 0)
                {
                    if(\DB::table('gallery_images')->where('id', $id)->delete())
                    {
                        $data = array(
                            'message'=>'Сликата е избришана !',
                            'message_class'=>'alert-success',
                        );
                        return json_encode($data);
                    }
                }
            }
       }
        $data = array(
            'message'=>'Сликата не може да се избрише !',
            'message_class'=>'alert-danger',
        );
        return json_encode($data);
    }

    public function uploadNewImages($gallery_id)
    {
        session(['gallery_id'=>$gallery_id]);
        session(['upload_images'=>'upload_new_images']);
        return view('auth.gallery_second');
    }

    public function updateGalleryInfo($id, Request $request)
    {
        $this->validate($request, [
            'title' => 'required|max:75',
            'description' => 'max:150',
        ]);
        $title=$_POST['title'];
        $description=$_POST['description'];
        $request->session()->forget('upload_images');

        $update_info=Gallery::find($id);
        $update_info->gallery_name=$title;
        $update_info->gallery_description=$description;

        if($update_info->save())
        {
            return redirect()->route('getEditGallery',['id'=>$id])
                ->with('status', 'Насловот и описот на галеријата се ажурирани !')
                ->with('status-class', 'alert-success');
        }
        return redirect()->route('getEditGallery',['id'=>$id])
            ->with('status', 'Насловот и описот на галеријата не може да се ажурираат !')
            ->with('status-class', 'alert-danger');
    }

    public function updateImageDescriptionAlt($id, Request $request)
    {
        $this->validate($request, [
            'image_alt' => 'max:250',
            'image_desc' => 'max:250',
        ]);

        $alt=$_POST['image_alt'];
        $desc=$_POST['image_desc'];

        $update_info=GalleryImage::find($id);
        $update_info->image_description=$desc;
        $update_info->image_alt=$alt;

        if($update_info->save())
        {
            $data = array(
                'message'=>'<span class="fa fa-check">Промените се зачувани !</span>',
                'message_class'=>'alert-success',
                'success_message'=>true,
                'desc'=>$update_info->image_description,
                'alt'=>$update_info->image_alt
            );
            return json_encode($data);
        }

        $data = array(
            'message'=>'<span class="fa fa-remove">Промените не се зачувани !</span>',
            'message_class'=>'alert-danger',
            'success_message'=>false,
            'desc'=>$update_info->image_description,
            'alt'=>$update_info->image_alt
        );
        return json_encode($data);
    }

    public function getCropImage($id)
    {
        $get_image=\DB::table('gallery_images')->find($id);

        $image=$get_image->image;
        $gallery_id=$get_image->gallery_id;
        $image_id=$get_image->id;

        session(['image'=>$image]);
        session(['gallery_id'=>$gallery_id]);
        session(['image_id'=>$image_id]);
        return view('auth.crop-image');
    }

    public function postCropImage($image_id, Request $request)
    {
        if(\Input::get('image')!=null&&\Input::get('w')!=null&&\Input::get('h')!=null&&\Input::get('x')!=null&&\Input::get('y')!=null)
        {
            $quality = 90;
            $src  = 'images/galleries/'.session('gallery_id').'/'.\Input::get('image');
            $img  = imagecreatefromjpeg($src);
            $dest = imagecreatetruecolor(\Input::get('w'), \Input::get('h'));

            imagecopyresampled($dest, $img, 0, 0, \Input::get('x'), \Input::get('y'), \Input::get('w'), \Input::get('h'), \Input::get('w'), \Input::get('h'));
            imagejpeg($dest, $src, $quality);

            \Image::make($src)->save($src);

            session(['image'=>\Input::get('image')]);
            return redirect()->back()
                ->with('status', 'Сликата е зачувана !')
                ->with('status-class', 'alert-success');
        }

        return redirect()->back()
            ->with('status', 'Сликата не може да се зачува ! Направете промена.')
            ->with('status-class', 'alert-danger');
    }

    public function postCropThumbnail($image_id, Request $request)
    {
        if(\Input::get('image')!=null&&\Input::get('w')!=null&&\Input::get('h')!=null&&\Input::get('x')!=null&&\Input::get('y')!=null) {

            $file = 'images/galleries/' . session('gallery_id') . '/' . \Input::get('image');
            $newfile = 'images/galleries/' . session('gallery_id') . '/temp/' . \Input::get('image');

            if (!file_exists('images/galleries/' . session('gallery_id') . '/temp/')) {
                mkdir('images/galleries/' . session('gallery_id') . '/temp/');
            }
            copy($file, $newfile);


            $quality = 90;
            $src = 'images/galleries/' . session('gallery_id') . '/temp/' . \Input::get('image');
            $img = imagecreatefromjpeg($src);
            $dest = imagecreatetruecolor(\Input::get('w'), \Input::get('h'));

            imagecopyresampled($dest, $img, 0, 0, \Input::get('x'), \Input::get('y'), \Input::get('w'), \Input::get('h'), \Input::get('w'), \Input::get('h'));
            imagejpeg($dest, $src, $quality);

            \Image::make($src)->resize(500, 500)->save($src);

            $file_2 = 'images/galleries/' . session('gallery_id') . '/temp/' . \Input::get('image');
            $newfile_2 = 'images/galleries/' . session('gallery_id') . '/thumbnails/' . \Input::get('image');
            if (copy($file_2, $newfile_2))
            {
                \File::deleteDirectory('images/galleries/'.session('gallery_id').'/temp');
            }

            return redirect()->back()
                ->with('status', 'Сликата е зачувана !')
                ->with('status-class', 'alert-success');
        }

        return redirect()->back()
            ->with('status', 'Сликата не може да се зачува ! Направете промена.')
            ->with('status-class', 'alert-danger');
    }

    public function addGalleryToPage($gallery_id)
    {
        $page_id=$_POST['page'];

        $gallery = Gallery::where('id', $gallery_id)->first();
        $page = Page::where('id', $page_id)->first();

        $page->galleries()->attach($gallery);

        return redirect()->route('getEditGallery',['id'=>$gallery_id])
            ->with('status', 'Галеријата е успешно додадена во '.$page->page_name)
            ->with('status-class', 'alert-success');
    }

    public function addGalleryToEvent($gallery_id)
    {
        $event_id=$_POST['event'];

        $gallery = Gallery::where('id', $gallery_id)->first();
        $event = Event::where('id', $event_id)->first();

        $event->galleries()->attach($gallery);

        return redirect()->route('getEditGallery',['id'=>$gallery_id])
            ->with('status', 'Галеријата е успешно додадена во '.$event->event_title)
            ->with('status-class', 'alert-success');
    }

    public function getEventsAdmin()
    {
        $events=\DB::table('events')->orderBy('id', 'desc')->paginate(8);
        return view('auth.events_admin', ['events'=>$events]);
    }

    public function createEvent(Request $request)
    {

        $validator = Validator::make($request->all(), [
            'title' => 'required|max:150',
            'description' => 'max:250',
            'category' => 'required',
            'content' => 'max:3000',
            'currency' => 'required',
            'size'=>'max:200',
            'color'=>'max:200',
            'mechanism'=>'max:200',
            'code'=>'max:200',
            'price_from'=>'numeric|sometimes|nullable',
            'price_to'=>'numeric|sometimes|nullable',
            'price.*'=>'numeric|sometimes|nullable'
        ]);

        $validator->sometimes('price_from', 'numeric|required', function ($input) {
            return !empty($input->price_to);
        });
        $validator->sometimes('price_to', 'numeric|required', function ($input) {
            return !empty($input->price_from);
        });

        if($validator->fails())
        {
            $val_messages = $validator->messages();
            $data = array(
                'product_title' => $val_messages->first('title'),
                'product_description' => $val_messages->first('description'),
                'product_category' => $val_messages->first('category'),
                'product_content' => $val_messages->first('content'),
                'product_size'=>$val_messages->first('size'),
                'product_color'=>$val_messages->first('color'),
                'product_mechanism'=>$val_messages->first('mechanism'),
                'product_code'=>$val_messages->first('code'),
                'product_price_from'=>$val_messages->first('price_from'),
                'product_price_to'=>$val_messages->first('price_to'),
                'product_price'=>$val_messages->first('price.*'),
                'status_class'=>'alert-danger',
                'product_validator' => 'fail_validator'
            );
            return json_encode($data);
        }

        $input=$request->all();

        $save_event = new Event();

        $title=$input['title'];

        $save_event->event_title = $title;

        if($input['currency']=='denar')
        {
            $save_event->currency='Ден.';
        }

        if($input['currency']=='euro')
        {
            $save_event->currency='&euro;';
        }

        if($input['currency']=='dolar')
        {
            $save_event->currency='$';
        }

        if($input['weight']=='none')
        {
            $save_event->weight=null;
        }

        if($input['weight']=='gr')
        {
            $save_event->weight='/gr';
        }

        $description=$input['description'];
        $save_event->event_description = $description;

        $content=$input['content'];
        $save_event->event_text = $content;

        $code=$input['code'];
        $save_event->code=$code;

        $size=$input['size'];
        $save_event->size=$size;

        $color=$input['color'];
        $save_event->color=$color;

        $mechanism=$input['mechanism'];
        $save_event->mechanism=$mechanism;

        $price_from=$input['price_from'];
        $price_to=$input['price_to'];

        if(!empty($input['price'][0])&&!empty($price_from)&&!empty($price_to))
        {
            $prices=implode(", ", array_filter($input['price']));
            $save_event->price=$prices;

            $save_event->price_from=$price_from;
            $save_event->price_to=$price_to;
        }
        if(!empty($price_from)&&!empty($price_to)&&empty($input['price'][0]))
        {
            $save_event->price_from=$price_from;
            $save_event->price_to=$price_to;
        }
        if(!empty($input['price'][0])&&(empty($price_from)&&empty($price_to)))
        {
            $prices=implode(", ", array_filter($input['price']));
            $save_event->price=$prices;

            $save_event->price_from=null;
            $save_event->price_to=null;
        }
        if(empty($input['price'][0])&&empty($price_from)&&empty($price_to))
        {
            $save_event->price=null;
            $save_event->price_from=null;
            $save_event->price_to=null;
        }


        $category=$input['category'];
        $save_event->category_id=$category;

        $save_event->user_id=Auth::id();


        if($save_event->save())
        {
            $data = array(
                'status_message' => 'Производот е успешно зачуван.',
                'status_class' => 'alert-success',
                'product_validator' => 'success',
            );
            return json_encode($data);
        }

        $data = array(
            'status_message' => 'Производот не е зачуван. Обидете се повторно.',
            'status_class' => 'alert-danger',
            'product_validator' => 'database_fail',
        );
        return json_encode($data);

    }

    public function getEditEvent($id)
    {
        $event=\DB::table('events')->find($id);

        $event_prices= explode(", ", $event->price);
        $event_price_from='';
        $event_price_to='';

        return view('auth.edit_event', [
            'event'=>$event,
            'event_prices'=>$event_prices
        ]);
    }

    public function removeGalleryEvent($gallery_id, $event_id)
    {
        $remove_gallery = Event::find($event_id);

        if($remove_gallery->galleries()->detach($gallery_id))
        {
            return redirect()->back()
                ->with('status', 'Галеријата е успешно отстранета !')
                ->with('status-class', 'alert-success');
        }
        return redirect()->back()
            ->with('status', 'Галеријата не може да се отстрани !')
            ->with('status-class', 'alert-danger');

    }

    public function removeGalleryPage($gallery_id, $page_id)
    {
        $remove_gallery = Page::find($page_id);

        if($remove_gallery->galleries()->detach($gallery_id))
        {
            return redirect()->back()
                ->with('status', 'Галеријата е успешно отстранета !')
                ->with('status-class', 'alert-success');
        }
        return redirect()->back()
            ->with('status', 'Галеријата не може да се отстрани !')
            ->with('status-class', 'alert-danger');

    }

    public function addEventToGallery($event_id)
    {
        $gallery_id=$_POST['gallery'];

        $event = Event::where('id', $event_id)->first();
        $gallery= Gallery::where('id', $gallery_id)->first();

        $gallery->events()->attach($event);

        return redirect()->route('getEditEvent',['id'=>$event_id])
            ->with('status', 'Галеријата е успешно додадена !')
            ->with('status-class', 'alert-success');
    }


    public function deleteEvent($id)
    {

        $event=Event::find($id);

        if($event->is_shown==1)
        {
            \DB::table('search_table')->where('foreign_key', $id)->delete();
        }

        if (\DB::table('gallery_event')->where('event_id', $id)->count() > 0)
        {
            \DB::table('gallery_event')->where('event_id', $id)->delete();
        }

        $event_delete=\DB::table('events')->where('id', $id)->delete();
        if($event_delete)
        {
            return redirect()->route('getEventsAdmin')
                ->with('status', 'Производот е успешно избришан !')
                ->with('status-class', 'alert-success');
        }

        return redirect()->route('getEventsAdmin')
            ->with('status', 'Производот не може да се избрише !')
            ->with('status-class', 'alert-danger');
    }

    public function makeEventVisible($id)
    {
        $event=Event::find($id);

        \DB::table('search_table')->insert(
            ['link_name' => $event->event_title, 'route' => '/event/'.$id, 'type' => 'event', 'foreign_key' => $id]
        );

        $event->is_shown=1;

        if($event->save())
        {
            return redirect()->route('getEditEvent',['id'=>$id])
                ->with('status', 'Производот е видлив на веб сајтот !')
                ->with('status-class', 'alert-success');
        }

        return redirect()->route('getEditEvent',['id'=>$id])
            ->with('status', 'Промената не е зачувана ! Обидете се повторно.')
            ->with('status-class', 'alert-danger');

    }

    public function makeEventHidden($id)
    {
        $event=Event::find($id);

        \DB::table('search_table')->where('foreign_key', $id)->delete();

        $event->is_shown=0;

        if($event->save())
        {
            return redirect()->route('getEditEvent',['id'=>$id])
                ->with('status', 'Производот е сокриен !')
                ->with('status-class', 'alert-success');
        }

        return redirect()->route('getEditEvent',['id'=>$id])
            ->with('status', 'Промената не е зачувана ! Обидете се повторно. ')
            ->with('status-class', 'alert-danger');
    }

    public function updateEvent($id, Request $request)
    {
        $validator = Validator::make($request->all(), [
            'title' => 'required|max:150',
            'description' => 'max:250',
            'category' => 'required',
            'content' => 'max:3000',
            'currency' => 'required',
            'size'=>'max:200',
            'color'=>'max:200',
            'mechanism'=>'max:200',
            'code'=>'max:200',
            'price_from'=>'numeric|sometimes|nullable',
            'price_to'=>'numeric|sometimes|nullable',
            'price.*'=>'numeric|sometimes|nullable'
        ]);


        $validator->sometimes('price_from', 'numeric|required', function ($input) {
            return !empty($input->price_to);
        });
        $validator->sometimes('price_to', 'numeric|required', function ($input) {
            return !empty($input->price_from);
        });

        if($validator->fails())
        {
            $val_messages = $validator->messages();
            $data = array(
                'product_title' => $val_messages->first('title'),
                'product_description' => $val_messages->first('description'),
                'product_category' => $val_messages->first('category'),
                'product_content' => $val_messages->first('content'),
                'product_size'=>$val_messages->first('size'),
                'product_color'=>$val_messages->first('color'),
                'product_mechanism'=>$val_messages->first('mechanism'),
                'product_code'=>$val_messages->first('code'),
                'product_price_from'=>$val_messages->first('price_from'),
                'product_price_to'=>$val_messages->first('price_to'),
                'product_price'=>$val_messages->first('price.*'),
                'status_class'=>'alert-danger',
                'product_validator' => 'fail_validator'
            );
            return json_encode($data);
        }

        $input=$request->all();

        $save_event = Event::find($id);

        $title=$input['title'];

        $save_event->event_title = $title;

        if($input['currency']=='denar')
        {
            $save_event->currency='Ден.';
        }

        if($input['currency']=='euro')
        {
            $save_event->currency='&euro;';
        }

        if($input['currency']=='dolar')
        {
            $save_event->currency='$';
        }

        if($input['weight']=='none')
        {
            $save_event->weight=null;
        }

        if($input['weight']=='gr')
        {
            $save_event->weight='/gr';
        }

        $description=$input['description'];
        $save_event->event_description = $description;

        $content=$input['content'];
        $save_event->event_text = $content;

        $code=$input['code'];
        $save_event->code=$code;

        $size=$input['size'];
        $save_event->size=$size;

        $color=$input['color'];
        $save_event->color=$color;

        $mechanism=$input['mechanism'];
        $save_event->mechanism=$mechanism;

        $price_from=$input['price_from'];
        $price_to=$input['price_to'];

        if(!empty($input['price'][0])&&!empty($price_from)&&!empty($price_to))
        {
            $prices=implode(", ", array_filter($input['price']));
            $save_event->price=$prices;

            $save_event->price_from=$price_from;
            $save_event->price_to=$price_to;
        }
        if(!empty($price_from)&&!empty($price_to)&&empty($input['price'][0]))
        {
            $save_event->price_from=$price_from;
            $save_event->price_to=$price_to;
        }
        if(!empty($input['price'][0])&&(empty($price_from)&&empty($price_to)))
        {
            $prices=implode(", ", array_filter($input['price']));
            $save_event->price=$prices;

            $save_event->price_from=null;
            $save_event->price_to=null;
        }
        if(empty($input['price'][0])&&empty($price_from)&&empty($price_to))
        {
            $save_event->price=null;
            $save_event->price_from=null;
            $save_event->price_to=null;
        }


        $category=$input['category'];
        $save_event->category_id=$category;

        $save_event->user_id=Auth::id();


        if($save_event->save())
        {
            $data = array(
                'status_message' => 'Производот е успешно ажуриран.',
                'status_class' => 'alert-success',
                'product_validator' => 'success',
            );
            return json_encode($data);
        }

        $data = array(
            'status_message' => 'Производот не е ажуриран. Обидете се повторно.',
            'status_class' => 'alert-danger',
            'product_validator' => 'database_fail',
        );
        return json_encode($data);

    }

    public function getAllGalleriesEvent($id)
    {
        $galleries=\DB::table('galleries')->orderBy('id', 'desc')->paginate(8);

        return view('auth.event_all_galleries', ['id'=>$id, 'galleries'=>$galleries]);
    }

    public function addEventToGalleryAll($gallery_id, $event_id)
    {

        $event = Event::where('id', $event_id)->first();
        $gallery= Gallery::where('id', $gallery_id)->first();

        $gallery->events()->attach($event);

        return redirect()->back()
            ->with('status', 'Галеријата е успешно додадена !')
            ->with('status-class', 'alert-success');
    }


    public function getVideosAdmin(Request $request)
    {

        $videos=\DB::table('videos')->orderBy('id', 'desc')->paginate(8);
        return view('auth.videos_admin', ['videos'=>$videos]);
    }

    public function createVideoFirst(Request $request)
    {

        $this->validate($request, [
            'title' => 'required|max:75',
            'description' => 'max:150',
            'code'=>'required'
        ]);

        $title=$_POST['title'];
        $description=$_POST['description'];
        $code=$_POST['code'];

        $video_id = explode("?v=", $code);
        if (empty($video_id[1]))
            $video_id = explode("/v/", $code);
        $video_id = explode("&", $video_id[1]);
        $video_id = $video_id[0];



        $code=$video_id;

        $video=new Video();
        $video->video_name=$title;
        $video->video_description=$description;
        $video->video_code=$code;
        if($video->save())
        {
            return redirect()->route('getVideosAdmin')
                ->with('status', 'Видеото е успешно додадено !')
                ->with('status-class', 'alert-success');
        }
        return redirect()->route('getVideo')
            ->with('status', 'Обидете се повторно !')
            ->with('status-class', 'alert-danger');

    }

    public function getEditVideo(Request $request, $id)
    {
        $video=\DB::table('videos')->find($id);

        return view('auth.edit_video', ['video'=>$video]);
    }



    /*
     * Delete gallery
     */

    public function deleteVideo($id)
    {

        if (\DB::table('video_event')->where('video_id', $id)->count() > 0)
        {
            \DB::table('video_event')->where('video_id', $id)->delete();
        }

        $video_delete=\DB::table('videos')->where('id', $id)->delete();
        if($video_delete)
        {
            return redirect()->route('getVideosAdmin')
                ->with('status', 'Видеото е успешно избришано !')
                ->with('status-class', 'alert-success');
        }

        return redirect()->route('getVideo')
            ->with('status', 'Видеото не може да се избрише !')
            ->with('status-class', 'alert-danger');
    }


    public function updateVideoInfo($id, Request $request)
    {
        $this->validate($request, [
            'title' => 'required|max:150',
            'description' => 'max:250',
            'code' => 'required',
        ]);
        $title=$_POST['title'];
        $description=$_POST['description'];
        $code=$_POST['code'];

        $video_id = explode("?v=", $code);
        if (empty($video_id[1]))
            $video_id = explode("/v/", $code);
        $video_id = explode("&", $video_id[1]);
        $video_id = $video_id[0];



        $code=$video_id;


        $update_info=Video::find($id);
        $update_info->video_name=$title;
        $update_info->video_description=$description;
        $update_info->video_code=$code;

        if($update_info->save())
        {
            return redirect()->route('getEditVideo',['id'=>$id])
                ->with('status', 'Податоците од видеото се ажурирани !')
                ->with('status-class', 'alert-success');
        }
        return redirect()->route('getEditVideo',['id'=>$id])
            ->with('status', 'Податоците од видеото не може да се ажурираат !')
            ->with('status-class', 'alert-danger');
    }

    public function addVideoToEvent($video_id)
    {
        $event_id=$_POST['event'];

        $video = Video::where('id', $video_id)->first();
        $event = Event::where('id', $event_id)->first();

        $event->videos()->attach($video);

        return redirect()->route('getEditVideo',['id'=>$video_id])
            ->with('status', 'Видеото е успешно додадено во '.$event->event_title)
            ->with('status-class', 'alert-success');
    }

    public function removeVideoEvent($video_id, $event_id)
    {
        $remove_video = Event::find($event_id);

        if($remove_video->videos()->detach($video_id))
        {
            return redirect()->back()
                ->with('status', 'Видеото е успешно отстрането !')
                ->with('status-class', 'alert-success');
        }
        return redirect()->back()
            ->with('status', 'Видеото не може да се отстрани !')
            ->with('status-class', 'alert-danger');

    }

    public function addEventToVideo($event_id)
    {
        $video_id=$_POST['video'];

        $event = Event::where('id', $event_id)->first();
        $video= Video::where('id', $video_id)->first();

        $video->events()->attach($event);

        return redirect()->route('getEditEvent',['id'=>$event_id])
            ->with('status', 'Видеото е успешно додадено !')
            ->with('status-class', 'alert-success');
    }

    public function getAllVideosEvent($id)
    {
        $videos=\DB::table('videos')->paginate(8);

        return view('auth.event_all_videos', ['id'=>$id, 'videos'=>$videos]);
    }

    public function addEventToVideoAll($video_id, $event_id)
    {

        $event = Event::where('id', $event_id)->first();
        $video= Video::where('id', $video_id)->first();

        $video->events()->attach($event);

        return redirect()->back()
            ->with('status', 'Видеото е успешно додадено !')
            ->with('status-class', 'alert-success');
    }

    public function deleteUser($id){

        $user = User::find($id);
        $user_roles = User::find($id)->roles();
        $user_events=Event::where('user_id', $id);

        if($user_events->count()>0)
        {
            $user_events->update(['user_id' => Auth::id()]);
        }

        if($user_roles->count()>0)
        {
            $user_roles->detach();
        }

        if($user->count()>0)
        {
            $user->delete();
        }

        return redirect()->route('getUsers')
            ->with('status', 'Корисникот е успешно избришан !')
            ->with('status-class', 'alert-success');

    }

    public function changeGalleryImageOrder(Request $request, $ids)
    {
        $idArray = explode(",", $ids);
        $count = 1;
        foreach ($idArray as $id){
            GalleryImage::where('id', $id)
                ->update(['image_order' => $count]);
            $count ++;
        }

        if ($request->ajax()) {
            $data = array(
                'message'=>'Промените се зачувани !',
            );
            return json_encode($data);

        }
        return redirect()->back();
    }

    public function getSortable(Request $request, $id)
    {
        $gallery=\DB::table('galleries')->find($id);

        return view('auth.sortable', ['gallery'=>$gallery]);
    }

    public function getPageGalleries(Request $request)
    {
        $galleries=Page::find(1)->galleries()->orderBy('gallery_order', 'asc')->get();
        return view('auth.page_galleries', ['galleries'=>$galleries]);
    }

    public function changeGalleryOrder(Request $request, $ids)
    {
        $idArray = explode(",", $ids);
        $count = 1;
        foreach ($idArray as $id){
            Gallery::where('id', $id)
                ->update(['gallery_order' => $count]);
            $count ++;
        }

        if ($request->ajax()) {
            $data = array(
                'message'=>'Промените се зачувани !',
            );
            return json_encode($data);

        }
        return redirect()->back();
    }

    public function addNewCategory(Request $request)
    {

        $validator = \Validator::make($request->all(), array(
            'category_name' => 'required|max:250',
        ));

        if($validator->fails())
        {
            $val_messages = $validator->messages();
            $data = array(
                'message' => $val_messages->first('category_name'),
                'message_class'=>'alert-danger',
                'validator' => 'fail_validator'
            );
            return json_encode($data);
        }

        $event_category= new EventCategory();
        $event_category->category_name=$_POST['category_name'];

        $event_category->category_slug=str_slug($_POST['category_name'], '-');

        if($event_category->save())
        {
            $data = array(
                'message'=>'Новиот тип на производ е успешно внесен !',
                'message_class'=>'alert-success',
                'validator' => 'success',
            );
            return json_encode($data);
        }

        $data = array(
            'message'=>'Новиот тип на производ не може да се зачува !',
            'message_class'=>'alert-danger',
            'validator' => 'fail_database',
        );
        return json_encode($data);

    }

    public function editCategory(Request $request, $id)
    {
        $validator = \Validator::make($request->all(), array(
            'category_name' => 'required|max:250',
        ));

        $category_name=$_POST['category_name'];

        $update_info=EventCategory::find($id);
        $update_info->category_name=$category_name;
        $update_info->category_slug=str_slug($category_name, '-');

        if($validator->fails())
        {
            $val_messages = $validator->messages();
            $data = array(
                'message' => $val_messages->first('category_name'),
                'message_class'=>'alert-danger',
                'validator' => 'fail_validator'
            );
            return json_encode($data);
        }

        if($update_info->save())
        {
            $data = array(
                'message'=>'Промените се зачувани !',
                'message_class'=>'alert-success',
                'validator' => 'success',
            );
            return json_encode($data);
        }

        $data = array(
            'message'=>'Промените не може да се зачуваат !',
            'message_class'=>'alert-danger',
            'validator' => 'fail_database',
        );
        return json_encode($data);

    }

    public function deleteCategory($id)
    {

        \DB::table('events')->where('category_id', $id)->update(['category_id' => 0]);

        if(\DB::table('event_categories')->where('id', $id)->delete())
        {
            $data = array(
                'message'=>'Категоријата е избришана !',
                'message_class'=>'alert-success',
            );
            return json_encode($data);
        }

        $data = array(
            'message'=>'Категоријата не може да се избрише !',
            'message_class'=>'alert-danger',
        );
        return json_encode($data);

    }
}

