<?php $__env->startSection('title'); ?>
    <title>Галерија</title>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('description'); ?>
    <meta name="description" content="Free Web tutorials">
<?php $__env->stopSection(); ?>
<?php $__env->startSection('keywords'); ?>
    <meta name="keywords" content="HTML,CSS,XML,JavaScript">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('styles'); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="container-fluid galleries top-margin">
        <div class="container-fluid">
            <div class="gallery-items">
                <?php $__currentLoopData = $galleries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $gallery): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="col-md-3 col-xs-6 items-galleries">
                        <div class="gallery-item">
                            <a href="javascript:void(0)" onclick="openGallery(<?php echo $gallery->id; ?>)">
                                <?php $__currentLoopData = \DB::table('gallery_images')->where('gallery_id', $gallery->id)->orderBy('image_order', 'asc')->limit(1)->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $gallery_image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <img src="<?php echo URL::asset('images/galleries'); ?>/<?php echo $gallery->id; ?>/<?php echo $gallery_image->thumbnail; ?>" class="img-responsive content-image img-thumbnail">
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <div class="middle">
                                    <div class="text" id="text-<?php echo $gallery->id; ?>">
                                        <span class="fa fa-search fa-2x"></span><br>
                                        Погледни
                                    </div>
                                </div>
                            </a>
                        </div>
                        <h3><?php echo $gallery->gallery_name; ?></h3>
                        <?php if(Auth::user()): ?>
                            <?php if(Auth::user()->hasRole('admin')||Auth::user()->hasRole('editor')): ?>
                                <div class="edit_gallery_page">
                                    <a href="<?php echo route('removeGalleryPage', ['gallery_id'=>$gallery->id, 'page_id'=>1]); ?>" class="btn btn-default btn-xs"><span class="fa fa-remove"></span></a>
                                    <a href="<?php echo route('getEditGallery', ['id'=>$gallery->id]); ?>" class="btn btn-default btn-xs"><span class="fa fa-pencil"></span></a>
                                </div>
                            <?php endif; ?>
                        <?php endif; ?>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
    <script>
        function openGallery(gallery_id)
        {
            $('#text-'+gallery_id).html('<span class="fa fa-spinner fa-spin fa-2x"></span><br>Погледни');
            $.ajax({
                url: 'gallery/'+gallery_id+'/images',
                dataType: 'json'
            }).done(function (data) {
                $('#text-'+gallery_id).html('<span class="fa fa-search fa-2x"></span><br>Погледни');
                $('.gallery-items').fadeOut(function () {
                    $("body").scrollTop();
                    $('.gallery-items').html(data).fadeIn();
                });
            }).fail(function () {
                alert('Images could not be loaded.');
            });
        }
    </script>
    <script>
        $(document).ready(function() {
            $("#galerija").addClass('active');
        });

        $('#za_nas').click(function(){
            window.location.href ='<?php echo route('getHome'); ?>#about-us';
        });

    </script>

    <script>
        var divs = $(".items-galleries");
        var i=0;

        if ($(window).width() >= 992) {
            for(i = 0; i < divs.length; i+=4) {
                divs.slice(i, i+4).wrapAll("<div class='row'></div>");
            }
        }

        else{
            for(i = 0; i < divs.length; i+=2) {
                divs.slice(i, i+2).wrapAll("<div class='row'></div>");
            }
        }
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layout', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>