@extends('layout')

@section('title')
    <title>Ohridski biser napraven od semejstvoto Talevi, ohridski biser prva klasa</title>
    @endsection
@section('description')
    <meta name="description" content="Ohridski biser, obetki, gerdan, narakvici, ohridski biser dvodelen, ohridski biser prva klasa">
@endsection
@section('keywords')
@endsection

@section('styles')
    <link rel="stylesheet" href="{!! url('css/owl.carousel.min.css') !!}">
    <link rel="stylesheet" type="text/css" href="{!! url('fancybox/dist/jquery.fancybox.min.css') !!}">
@endsection

@section('content')
    <header>
        <div id="carousel-example-generic" class="carousel slide carousel-fade" data-ride="carousel">
            <!-- Wrapper for slides -->
            <div class="carousel-inner" role="listbox">

                <!-- First slide -->
                <div class="item active item-1">
                    <div class="fill" style="background-image:url('{!! url('images/slide1.jpg') !!}');"></div>
                    <div class="carousel-caption">
                        <h3 data-animation="animated fadeIn">
                            Jewellery are like the perfect spice,
                            it always complements whats already there.<br>
                            <small>Diane von Furstenberg</small>
                        </h3>
                    </div>
                </div><!-- /.item -->

                <!-- Second slide -->
                <div class="item item-2">
                    <div class="fill" style="background-image:url('{!! url('images/slide2.jpg') !!}');"></div>
                    <div class="carousel-caption">
                        <h3 data-animation="animated fadeIn">
                            Pearls are always appropriate<br>
                            <small>Jackie O. Cannady</small>
                        </h3>
                    </div>
                </div><!-- /.item -->


                <div class="item item-3">
                    <div class="fill" style="background-image:url('{!! url('images/slide3.jpg') !!}');"></div>
                    <div class="carousel-caption">
                        <h3 data-animation="animated fadeIn">
                            The best things in life are free. The second best are expensive.<br>
                            <small>Cocco Chanel</small>
                        </h3>
                    </div>
                </div><!-- /.item -->

            </div><!-- /.carousel-inner -->

            <!-- Controls -->
            <a class="left carousel-control" href="#carousel-example-generic"
               role="button" data-slide="prev">
                <span class="fa fa-chevron-left" aria-hidden="true"></span>
                <span class="sr-only">Previous</span>
            </a>
            <a class="right carousel-control" href="#carousel-example-generic"
               role="button" data-slide="next">
                <span class="fa fa-chevron-right" aria-hidden="true"></span>
                <span class="sr-only">Next</span>
            </a>
        </div><!-- /.carousel -->
    </header>
    @if($event_categories->count()>0)
        <section class="container-fluid products-home text-center">
            <h1>Нашите Охридски бисери</h1>
            <div class="row">
                <div class="owl-carousel owl-theme" id="news-slider-1">
                    @foreach($event_categories as $event_category)
                        @if(App\EventCategory::find($event_category->id)->events()->count()>0)
                            @foreach(App\EventCategory::find($event_category->id)->events()->limit(1)->get() as $event)
                                <div class="category_item">
                                    <div class="product-image gallery-item">
                                        @if(App\Event::find($event->id)->galleries()->count()>0)
                                            @foreach(App\Event::find($event->id)->galleries()->limit(1)->get() as $event_gallery)
                                                @foreach(\DB::table('gallery_images')->where('gallery_id', $event_gallery->id)->orderBy('image_order', 'asc')->limit(1)->get() as $gallery_image)
                                                    <a href="{!! route('getProductCategory', ['id'=>$event_category->id, 'slug'=>$event_category->category_slug]) !!}">
                                                        <img src="{!! URL::asset('images/galleries') !!}/{!! $event_gallery->id !!}/{!! $gallery_image->thumbnail !!}" class="img-responsive content-image">
                                                        <div class="middle">
                                                            <div class="text">
                                                                <span class="fa fa-search fa-2x"></span><br>
                                                                Погледни
                                                            </div>
                                                        </div>
                                                    </a>
                                                @endforeach
                                            @endforeach
                                        @else
                                            <img src="{!! url('images/product_placeholder.png') !!}" class="img-responsive">
                                        @endif
                                    </div>
                                    <div class="product-review">
                                        <h2 class="product-title">
                                            <a href="{!! route('getProductCategory', ['id'=>$event_category->id, 'slug'=>$event_category->category_slug]) !!}">{!! $event_category->category_name !!}</a>
                                        </h2>
                                        <br>
                                        <a href="{!! route('getProductCategory', ['id'=>$event_category->id, 'slug'=>$event_category->category_slug]) !!}" class="show-more-btn">
                                            Повеќе
                                            <span class="fa fa-eye"></span>
                                        </a>
                                    </div>
                                </div>
                            @endforeach
                        @endif
                    @endforeach
                </div>
            </div>
        </section>
    @endif
    <section class="container about-us text-center" id="about_us">
        <h2>За нас</h2>
        <div class="row">
            <div class="col-md-3">
                <div>
                    <div class="about-us-img img-thumbnail">
                        <img src="{!! url('images/tradicija/VaneTatko-min.jpg') !!}" class="img-responsive">
                        <h4>Татко на Климент, Ване иноватор на Охридскиот Бисер</h4>
                    </div>
                    <div class="about-us-img img-thumbnail">
                        <img src="{!! url('images/tradicija/prodazba-min.jpg') !!}" class="img-responsive">
                        <h4>Продажба на Охридски Бисери 1935 год</h4>
                    </div>
                    <div class="about-us-img img-thumbnail">
                        <img class="img-responsive" src="{!! url('images/tradicija/elizabeth.jpg') !!}">
                        <h4>Кралицата Елизабета носи Охридски Бисер направен од смејството Талеви</h4>
                    </div>
                </div>
            </div>
            <div class="col-md-6">
                <div class="about-us-img-big img-thumbnail">
                    <img src="{!! url('images/tradicija/izrabotka-min.jpg') !!}" class="img-responsive">
                    <h4>Таткото од Климент - Ване во работилница 1935</h4>
                </div>
                <div class="about-us-item">
                    <h3>Нашата долга традиција</h3>
                    <div class="about-us-text">
                        <p>
                            <img src="{!! url('images/logo.png') !!}" class="logo-about img-thumbnail">
                            Фамилијарниот бизнис го почнале неговиот татко Ване (сликата десно) и Стрико му Михаил, кои во 1924 година од некој човек во Русија, за 25 наполеони купиле формула за правење бисер. Михаил од Витлеем купил материјали за изработка на бисери и така почнале да работат.</p>
                        <p>Имотните луѓе почнале да купуваат од нив, зошто само богатите луѓе можеле да си ги дозволат бисерите. Во дуќанот доаѓале трговци, сопственици на банки, млади индустријалци и купувале бисери за свршениците и за сопругите. Тогаш бисерите не се викаа охридски. Тоа име го добија во 1935 година. Трговиците од Битола и од Скопје, кои најмногу купувале, кажувале дека одат во Охрид по бисер, да купат бисер во Охрид и така го добиле сегашното име – раскажува Талев.</p>
                        <p>Охридските бисери се многу ценети и барани во светот. Тие се изработуваат од седеф и од школки, кои Талеви ги набавуваат од странство. Секое зрно бисер тие го изработуваат рачно, за што издаваат сертификати. Пред да почне со работа,Талев ги става зрната бисер на чепкалки и ги реди на дрвена штица долга еден метар. Секое зрно се премачкува со специјална емулзија, која е семејна тајна.</p>
                        <p>Работиме само со природни материјали. Дури и четчето со кое ги премачкувам бисерите е изработено од влакна од верверичка или од коњ. А емулзијата ја има истата формула што ја купиле татко ми и стрико ми во далечната 1924 година – вели Климент Талев.</p>
                        <p>Секој бисер се мачка пет до шест пати, а од едно до друго мачкање треба да поминат најмалку 45 минути до еден час, за добро да се исушат. Талев вели дека не е препорачливо бисерите да се нижат истиот ден кога се направени, туку е најдобро тоа да се прави следниот ден.</p>
                        <p>Многу познати личности од Мaкадонија и од странство носат бисери од Талеви. Едни од нив се претседателот Бранко Црвенкоски, амбасадорката на Кина, сопругата на Јапонскиот амбасадор, вице премиер на Луксембург, сопругата на МНР на Тајван, МНР на Р. Бугарија - Н. Михајлова, Г-ца Фалк Ал Хасад - сестра на Сирскиот крал, Г-ца Евелин Херфкенс - Холандија, Ана Линд МНР на Шведска, Марија Тисен - НАТО, Ридер - Австрија и др.</p>
                    </div>
                    <div class="about-us-text">
                    </div>
                </div>

                <div class="about-us-item working-process text-left">
                    <h3>Работниот процес</h3>
                    <p>На сликите е прикажано како Климент и Ване ги премачкуваат бисерите, рачно, технологија стара повеќе од 90 гоини.</p>
                    <div class="col-sm-4 col-xs-6 item-images">
                        <div class="gallery-image-item">
                            <a class="grouped_elements" href="{!! URL::asset('images/raboten_proces/rab1-min.jpg')!!}" data-fancybox="group">
                                <img src="{!! URL::asset('images/raboten_proces/thumb/rab1-min.jpg')!!}" alt="" class="img-responsive img-thumbnail"/>
                            </a>
                        </div>
                    </div>
                    <div class="col-sm-4 col-xs-6 item-images">
                        <div class="gallery-image-item">
                            <a class="grouped_elements" href="{!! URL::asset('images/raboten_proces/rab2-min.jpg')!!}" data-fancybox="group">
                                <img src="{!! URL::asset('images/raboten_proces/thumb/rab2-min.jpg')!!}" alt="" class="img-responsive img-thumbnail"/>
                            </a>
                        </div>
                    </div>
                    <div class="col-sm-4 col-xs-6 item-images">
                        <div class="gallery-image-item">
                            <a class="grouped_elements" href="{!! URL::asset('images/raboten_proces/rab3-min.jpg')!!}" data-fancybox="group">
                                <img src="{!! URL::asset('images/raboten_proces/thumb/rab3-min.jpg')!!}" alt="" class="img-responsive img-thumbnail"/>
                            </a>
                        </div>
                    </div>
                    <div class="col-sm-4 col-xs-6 item-images">
                        <div class="gallery-image-item">
                            <a class="grouped_elements" href="{!! URL::asset('images/raboten_proces/rab4-min.jpg')!!}" data-fancybox="group">
                                <img src="{!! URL::asset('images/raboten_proces/thumb/rab4-min.jpg')!!}" alt="" class="img-responsive img-thumbnail"/>
                            </a>
                        </div>
                    </div>
                    <div class="col-sm-4 col-xs-6 item-images">
                        <div class="gallery-image-item">
                            <a class="grouped_elements" href="{!! URL::asset('images/raboten_proces/rab5-min.jpg')!!}" data-fancybox="group">
                                <img src="{!! URL::asset('images/raboten_proces/thumb/rab5-min.jpg')!!}" alt="" class="img-responsive img-thumbnail"/>
                            </a>
                        </div>
                    </div>
                    <div class="col-sm-4 col-xs-6 item-images">
                        <div class="gallery-image-item">
                            <a class="grouped_elements" href="{!! URL::asset('images/raboten_proces/rab6-min.jpg')!!}" data-fancybox="group">
                                <img src="{!! URL::asset('images/raboten_proces/thumb/rab6-min.jpg')!!}" alt="" class="img-responsive img-thumbnail"/>
                            </a>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div>
                    <div class="about-us-img img-thumbnail">
                        <img src="{!! url('images/sertifikati/cert1.jpg') !!}" class="img-responsive">
                        <h4>Сертификат "Коректна Фирма"</h4>
                    </div>
                    <div class="about-us-img img-thumbnail">
                        <img src="{!! url('images/sertifikati/cert2.jpg') !!}" class="img-responsive">
                        <h4>Оригинален "Охридски Бисер Талеви"</h4>
                    </div>
                    <div class="about-us-img img-thumbnail">
                        <img src="{!! url('images/sertifikati/medalG.jpg') !!}" class="img-responsive">
                        <h4>Златен медал Еурека 2001</h4>
                        <p>Во 2001 година, на саемот за иновации и рачна изработка “Еурека“ во Брисел, Талеви освоија златен медал за рачна изработка на бисер во конуренција од над 45 рачни изработки од целиот свет</p>
                    </div>
                    <div class="about-us-img img-thumbnail">
                        <img src="{!! url('images/sertifikati/croatiaG.jpg') !!}" class="img-responsive">
                        <h4> Благодарница, пофалница- -Република Хрватска</h4>
                    </div>
                    <div class="about-us-img img-thumbnail">
                        <img class="img-responsive" src="{!! url('images/sertifikati/DiplomaEurekaG.jpg') !!}">
                        <h4>Диплома Еурека 2001- -Брисел</h4>
                    </div>
                    <div class="about-us-img img-thumbnail">
                        <img class="img-responsive" src="{!! url('images/sertifikati/GeographicalG.jpg') !!}">
                        <h4>Сертификат од Министерство за Економија на Македонија </h4>
                    </div>
                </div>
            </div>
        </div>
    </section>
    @endsection

@section('scripts')
    <script>
        var $myCarousel = $('#carousel-example-generic');
        $myCarousel.carousel();

        function doAnimations(elems) {
            var animEndEv = 'webkitAnimationEnd animationend';

            elems.each(function () {
                var $this = $(this),
                        $animationType = $this.data('animation');
                $this.addClass($animationType).one(animEndEv, function () {
                    $this.removeClass($animationType);
                });
            });
        }

        var $firstAnimatingElems = $myCarousel.find('.item:first')
                .find('[data-animation ^= "animated"]');
        doAnimations($firstAnimatingElems);
        $myCarousel.carousel('pause');
        $myCarousel.on('slide.bs.carousel', function (e) {
            // Select the elements to be animated inside the active slide
            var $animatingElems = $(e.relatedTarget)
                    .find("[data-animation ^= 'animated']");
            doAnimations($animatingElems);
        });



        var $item = $('.carousel .item');
        var $wHeight = $(window).height();
        $item.eq(0).addClass('active');
        $item.height($wHeight);
        $item.addClass('full-screen');

        $('.carousel img').each(function() {
            var $src = $(this).attr('src');
            var $color = $(this).attr('data-color');
            $(this).parent().css({
                'background-image' : 'url(' + $src + ')',
                'background-color' : $color
            });
            $(this).remove();
        });

        $(window).on('resize', function (){
            $wHeight = $(window).height();
            $item.height($wHeight);
        });

        $('.carousel').carousel({
            interval: 6000,
            pause: "false"
        });

    </script>
    <script src="{!! url('js/owl.carousel.min.js') !!}"></script>
    <script>
        $('.owl-carousel').owlCarousel({
            loop:true,
            margin:0,
            autoplay: true,
            responsiveClass:true,
            navText : ["<i class='fa fa-chevron-left'></i>","<i class='fa fa-chevron-right'></i>"],
            responsive:{
                0:{
                    items:1,
                    nav:true
                },
                600:{
                    items:3,
                    nav:true
                },
                1000:{
                    items:4,
                    nav:true,
                    loop:false
                }
            }
        })
    </script>
    <script src="{!! url('fancybox/dist/jquery.fancybox.min.js') !!}"></script>
    <script type="text/javascript">
        $("[data-fancybox].working-process").fancybox({
            // Options will go here

        });
    </script>

    <script>
        $(document).ready(function() {
            $("#pocetna").addClass('active');

            $('#za_nas').click(function(e){
                e.preventDefault();
                $('html, body').animate({
                    scrollTop: $('#about_us').offset().top-60
                }, 1000);
                $("#pocetna").removeClass('active');
                $("#za_nas").addClass('active');
            });

            $('#pocetna').click(function(e){
                e.preventDefault();
                $('html, body').animate({
                    scrollTop: $('body').offset().top
                }, 1000);
                $("#za_nas").removeClass('active');
                $("#pocetna").addClass('active');
            });
        });

        $(document).ready(function () {
            var hash = window.location.hash;
            if(hash=='#about-us'){
                $('html, body').animate({
                    scrollTop: $('#about_us').offset().top-80
                }, 500);
            }
        });
    </script>
@endsection