@extends('layout')

@section('title')
    <title>Galerija ohridski biser Talevi</title>
@endsection
@section('description')
    <meta name="description" content="Galerija Ohridski biser napraven od semejstvoto talevi">
@endsection
@section('keywords')
@endsection

@section('styles')
@endsection

@section('content')
    <div class="container-fluid galleries top-margin">
        <div class="container-fluid">
            <div class="gallery-items">
                @foreach($galleries as $gallery)
                    <div class="col-md-3 col-xs-6 items-galleries">
                        <div class="gallery-item">
                            <a href="javascript:void(0)" onclick="openGallery({!! $gallery->id !!})">
                                @foreach(\DB::table('gallery_images')->where('gallery_id', $gallery->id)->orderBy('image_order', 'asc')->limit(1)->get() as $gallery_image)
                                    <img src="{!! URL::asset('images/galleries') !!}/{!! $gallery->id !!}/{!! $gallery_image->thumbnail !!}" class="img-responsive content-image img-thumbnail">
                                @endforeach
                                <div class="middle">
                                    <div class="text" id="text-{!! $gallery->id !!}">
                                        <span class="fa fa-search fa-2x"></span><br>
                                        Погледни
                                    </div>
                                </div>
                            </a>
                        </div>
                        <h3>{!! $gallery->gallery_name !!}</h3>
                        @if(Auth::user())
                            @if(Auth::user()->hasRole('admin')||Auth::user()->hasRole('editor'))
                                <div class="edit_gallery_page">
                                    <a href="{!! route('removeGalleryPage', ['gallery_id'=>$gallery->id, 'page_id'=>1]) !!}" class="btn btn-default btn-xs"><span class="fa fa-remove"></span></a>
                                    <a href="{!! route('getEditGallery', ['id'=>$gallery->id]) !!}" class="btn btn-default btn-xs"><span class="fa fa-pencil"></span></a>
                                </div>
                            @endif
                        @endif
                    </div>
                @endforeach
            </div>
        </div>
    </div>
@endsection

@section('scripts')
    <script>
        function openGallery(gallery_id)
        {
            $('#text-'+gallery_id).html('<span class="fa fa-spinner fa-spin fa-2x"></span><br>Погледни');
            $.ajax({
                url: 'galerija/'+gallery_id+'/images',
                dataType: 'json'
            }).done(function (data) {
                $('#text-'+gallery_id).html('<span class="fa fa-search fa-2x"></span><br>Погледни');
                $('.gallery-items').fadeOut(function () {
                    $("body").scrollTop();
                    $('.gallery-items').html(data).fadeIn();
                });
            }).fail(function () {
                alert('Images could not be loaded.');
            });
        }
    </script>
    <script>
        $(document).ready(function() {
            $("#galerija").addClass('active');
        });

        $('#za_nas').click(function(){
            window.location.href ='{!! route('getHome') !!}#about-us';
        });

    </script>

    <script>
        var divs = $(".items-galleries");
        var i=0;

        if ($(window).width() >= 992) {
            for(i = 0; i < divs.length; i+=4) {
                divs.slice(i, i+4).wrapAll("<div class='row'></div>");
            }
        }

        else{
            for(i = 0; i < divs.length; i+=2) {
                divs.slice(i, i+2).wrapAll("<div class='row'></div>");
            }
        }
    </script>
@endsection