<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Event extends Model
{
    public function user()
    {
        return $this->belongsTo('App\User');
    }
    public function event_category()
    {
        return $this->belongsTo('App\Event');
    }
    public function galleries()
    {
        return $this->belongsToMany('App\Gallery', 'gallery_event', 'event_id', 'gallery_id');
    }

    public function videos()
    {
        return $this->belongsToMany('App\Video', 'video_event', 'event_id', 'video_id');
    }
}
