<?php $__env->startSection('styles'); ?>
    <link rel="stylesheet" href="<?php echo URL::asset('css/admin.css'); ?>">
    <script src="<?php echo URL::asset('js/jquery.min.js'); ?>"></script>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="container top-margin">
        <div class="row">
            <div class="col-md-12">
                <div class="panel panel-primary top-panel-margin">
                    <div class="panel-heading">
                        <span class="fa fa-youtube-play"></span> Видео "<?php echo $video->video_name; ?>"
                        <a href="" class="btn btn-sm btn-danger" style="float:right" data-toggle="modal" data-target="#modal-delete-<?php echo $video->id; ?>">
                            <span class="fa fa-trash-o"></span>
                        </a>
                        <div class="modal fade" id="modal-delete-<?php echo $video->id; ?>">
                            <div class="modal-dialog">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <button type="button" class="close" data-dismiss="modal">&times;</button>
                                        <h4 class="modal-title">Избриши видео</h4>
                                    </div>
                                    <div class="modal-body grey-bg">
                                        <p>
                                            Дали сте сигурни дека сакате да го избришете видеото "<?php echo $video->video_name; ?>"?<br>
                                            <small><i><b>Напомена: </b>видеото ќе биде избришано од сите страници !</i></small>
                                        </p>
                                    </div>
                                    <div class="modal-footer grey-bg">
                                        <a href="<?php echo URL::route('deleteVideo', ['id'=>$video->id]); ?>" class="btn btn-danger">Избриши&nbsp; <span class="fa fa-trash-o"></span>
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <a href="<?php echo route('getVideosAdmin'); ?>" class="btn btn-sm btn-primary" style="float:right; margin-right:2px;">
                            <span class="fa fa-arrow-left"></span>
                            Видеа
                        </a>
                    </div>

                    <div class="panel-body">
                        <?php if(session('status')): ?>
                            <div class="alert <?php echo session('status-class'); ?> alert-dismissable fade in">
                                <a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>
                                <?php echo session('status'); ?>

                            </div>
                        <?php endif; ?>
                        <div class="row">
                            <div class="row">
                                <div class="col-md-6">
                                    <form class="form-horizontal" role="form" method="POST" action="<?php echo route('updateVideoInfo', ['id'=>$video->id]); ?>" novalidate>
                                        <?php echo e(csrf_field()); ?>

                                        <div class="form-group<?php echo e($errors->has('title') ? ' has-error' : ''); ?> col-md-12">
                                            <hr>
                                            <label for="title" class="col-md-12">Наслов</label>
                                            <div class="col-md-12">
                                                <input id="title" type="text" class="form-control" name="title" value="<?php echo e($video->video_name); ?>">
                                                <?php if($errors->has('title')): ?>
                                                    <span class="help-block">
                                                        <strong><?php echo e($errors->first('title')); ?></strong>
                                                    </span>
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                        <div class="form-group<?php echo e($errors->has('description') ? ' has-error' : ''); ?> col-md-12">
                                            <label for="description" class="col-md-12">Краток опис</label>
                                            <div class="col-md-12">
                                                <textarea id="description" class="form-control" name="description"><?php echo e($video->video_description); ?></textarea>
                                                <?php if($errors->has('description')): ?>
                                                    <span class="help-block">
                                                        <strong><?php echo e($errors->first('description')); ?></strong>
                                                    </span>
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                        <div class="form-group<?php echo e($errors->has('code') ? ' has-error' : ''); ?> col-md-12">
                                            <label for="code" class="col-md-12">Url</label>
                                            <div class="col-md-12">
                                                <textarea id="code" class="form-control" name="code">https://www.youtube.com/watch?v=<?php echo $video->video_code; ?></textarea>
                                                <?php if($errors->has('code')): ?>
                                                    <span class="help-block">
                                                        <strong><?php echo e($errors->first('code')); ?></strong>
                                                    </span>
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                        <div class="col-md-12">
                                            <button type="submit" class="btn btn-success">
                                                ЗАЧУВАЈ
                                                <i class="fa fa-save" aria-hidden="true"></i>
                                            </button>
                                        </div>
                                    </form>
                                </div>
                                <div class="col-md-6">
                                    <form action="<?php echo route('addVideoToEvent', ['video_id'=>$video->id]); ?>" method="post" novalidate>
                                        <?php echo csrf_field(); ?>

                                        <div class="form-group col-md-12">
                                            <hr>
                                            <label for="page" class="col-md-12 col-xs-12">Додади видео на настан</label>
                                            <div class="col-md-8 col-xs-12">
                                                <select name="event" id="event" class="form-control">
                                                    <!--listaj na koi strani e dodadeno-->
                                                    <?php $__currentLoopData = App\Event::orderBy('id', 'desc')->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $event): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <option value="<?php echo $event->id; ?>" <?php echo App\Video::find($video->id)->events()->where('event_id', $event->id)->exists() ? 'disabled' : ''; ?>><?php echo $event->event_title; ?></option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </select>
                                            </div>
                                            <div class="col-md-2 col-xs-12">
                                                <button class="btn btn-sm btn-success">
                                                    Додади &nbsp;
                                                    <span class="fa fa-save"> </span>
                                                </button>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                                <div class="col-md-6">
                                    <iframe width="100%" height="350" style="padding:30px;" src="https://www.youtube.com/embed/<?php echo $video->video_code; ?>" frameborder="0" allowfullscreen></iframe>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layout', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>