<?php $__env->startSection('title'); ?>
    <title><?php echo $event_category->category_name; ?></title>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('description'); ?>
    <meta name="description" content="<?php echo $event_category->category_name; ?>">
<?php $__env->stopSection(); ?>
<?php $__env->startSection('keywords'); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('styles'); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <section class="container-fluid products top-margin text-center">
        <div class="row">
            <div class="col-xs-10 text-left gallery-title">
                <h1><?php echo $event_category->category_name; ?></h1>
            </div>
            <div class="col-xs-2 text-right">
                <a href="<?php echo route('getProducts'); ?>" class="btn btn-default gallery_back">
                    <span class="fa fa-arrow-left"></span>
                </a>
            </div>
        </div>
        <?php if(App\EventCategory::find($event_category->id)->events()->count()>0): ?>
            <?php $__currentLoopData = $events; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $event): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="col-md-3 gallery_item_wrap">
                    <div class="category_item">
                        <div class="product-image gallery-item">
                            <?php if(App\Event::find($event->id)->galleries()->count()>0): ?>
                                <?php $__currentLoopData = App\Event::find($event->id)->galleries()->limit(1)->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $event_gallery): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php $__currentLoopData = \DB::table('gallery_images')->where('gallery_id', $event_gallery->id)->orderBy('image_order', 'asc')->limit(1)->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $gallery_image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <a href="<?php echo route('getProduct', ['id'=>$event->id]); ?>">
                                            <img src="<?php echo URL::asset('images/galleries'); ?>/<?php echo $event_gallery->id; ?>/<?php echo $gallery_image->thumbnail; ?>" class="img-responsive content-image">
                                            <div class="middle">
                                                <div class="text">
                                                    <span class="fa fa-search fa-2x"></span><br>
                                                    Погледни
                                                    <?php if(Auth::user()): ?>
                                                        <?php if(Auth::user()->hasRole('admin')||Auth::user()->hasRole('editor')): ?>
                                                            <br>
                                                            <a href="<?php echo route('getEditEvent', ['id'=>$event->id]); ?>" class="btn btn-primary btn-xs"><span class="fa fa-pencil"></span></a>
                                                        <?php endif; ?>
                                                    <?php endif; ?>
                                                </div>
                                            </div>
                                        </a>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php else: ?>
                                <img src="<?php echo url('images/product_placeholder.png'); ?>" class="img-responsive">
                            <?php endif; ?>
                        </div>
                        <div class="product-review">
                            <h3 class="product-title">
                                <a href="<?php echo route('getProduct', ['id'=>$event->id]); ?>"><?php echo $event->event_title; ?></a>
                            </h3>
                            <p><?php echo $event-> event_description; ?></p>
                            <br>
                            <a href="<?php echo route('getProduct', ['id'=>$event->id]); ?>" class="show-more-btn">
                                Повеќе
                                <span class="fa fa-eye"></span>
                            </a>
                        </div>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <?php endif; ?>
    </section>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
    <script>
        $(document).ready(function() {
            $("#biseri").addClass('active');
        });
    </script>

    <script>
        var divs = $(".gallery_item_wrap");
        var i=0;

        if ($(window).width() >= 992) {
            for(i = 0; i < divs.length; i+=4) {
                divs.slice(i, i+4).wrapAll("<div class='row'></div>");
            }
        }

    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layout', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>