<?php $__env->startSection('title'); ?>
    <title>Ohrid pearls - made by Talevi, unique natural pearls</title>
    <?php $__env->stopSection(); ?>
<?php $__env->startSection('description'); ?>
    <meta name="description" content="Ohrid Pearls made by Talevi family. Ohrid family Talevi is a synonym of unique, natural pearls with tradition more than 90 years.">
<?php $__env->stopSection(); ?>
<?php $__env->startSection('keywords'); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('styles'); ?>
    <link rel="stylesheet" href="<?php echo url('css/owl.carousel.min.css'); ?>">
    <link rel="stylesheet" href="<?php echo url('css/owl.theme.default.min.css'); ?>">
    <link rel="stylesheet" type="text/css" href="<?php echo url('fancybox/dist/jquery.fancybox.min.css'); ?>">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <header>
        <div id="carousel-example-generic" class="carousel slide carousel-fade" data-ride="carousel">
            <!-- Wrapper for slides -->
            <div class="carousel-inner" role="listbox">

                <!-- First slide -->
                <div class="item active item-1">
                    <div class="fill" style="background-image:url('<?php echo url('images/slide1.jpg'); ?>');"></div>
                    <div class="carousel-caption">
                        <h3 data-animation="animated fadeIn">
                            Jewellery are like the perfect spice,
                            it always complements whats already there.<br>
                            <small>Diane von Furstenberg</small>
                        </h3>
                    </div>
                </div><!-- /.item -->

                <!-- Second slide -->
                <div class="item item-2">
                    <div class="fill" style="background-image:url('<?php echo url('images/slide2.jpg'); ?>');"></div>
                    <div class="carousel-caption">
                        <h3 data-animation="animated fadeIn">
                            Pearls are always appropriate<br>
                            <small>Jackie O. Cannady</small>
                        </h3>
                    </div>
                </div><!-- /.item -->


                <div class="item item-3">
                    <div class="fill" style="background-image:url('<?php echo url('images/slide3.jpg'); ?>');"></div>
                    <div class="carousel-caption">
                        <h3 data-animation="animated fadeIn">
                            The best things in life are free. The second best are expensive.<br>
                            <small>Cocco Chanel</small>
                        </h3>
                    </div>
                </div><!-- /.item -->

            </div><!-- /.carousel-inner -->

            <!-- Controls -->
            <a class="left carousel-control" href="#carousel-example-generic"
               role="button" data-slide="prev">
                <span class="fa fa-chevron-left" aria-hidden="true"></span>
                <span class="sr-only">Previous</span>
            </a>
            <a class="right carousel-control" href="#carousel-example-generic"
               role="button" data-slide="next">
                <span class="fa fa-chevron-right" aria-hidden="true"></span>
                <span class="sr-only">Next</span>
            </a>
        </div><!-- /.carousel -->
    </header>
    <?php if($event_categories->count()>0): ?>
        <section class="container-fluid products-home text-center">
            <h1>Our natural Ohrid pearls</h1>
            <div class="row">
                <div class="owl-carousel owl-theme" id="news-slider-1">
                    <?php $__currentLoopData = $event_categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $event_category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php if(App\EventCategory::find($event_category->id)->events()->count()>0): ?>
                            <?php $__currentLoopData = App\EventCategory::find($event_category->id)->events()->limit(1)->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $event): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="category_item">
                                    <div class="product-image gallery-item">
                                        <?php if(App\Event::find($event->id)->galleries()->count()>0): ?>
                                            <?php $__currentLoopData = App\Event::find($event->id)->galleries()->limit(1)->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $event_gallery): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <?php $__currentLoopData = \DB::table('gallery_images')->where('gallery_id', $event_gallery->id)->orderBy('image_order', 'asc')->limit(1)->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $gallery_image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <a href="<?php echo route('getProductCategory', ['id'=>$event_category->id, 'slug'=>$event_category->category_slug]); ?>">
                                                        <img src="<?php echo URL::asset('images/galleries'); ?>/<?php echo $event_gallery->id; ?>/<?php echo $gallery_image->thumbnail; ?>" class="img-responsive content-image">
                                                        <div class="middle">
                                                            <div class="text">
                                                                <span class="fa fa-search fa-2x"></span><br>
                                                                Open
                                                            </div>
                                                        </div>
                                                    </a>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        <?php else: ?>
                                            <img src="<?php echo url('images/product_placeholder.png'); ?>" class="img-responsive">
                                        <?php endif; ?>
                                    </div>
                                    <div class="product-review">
                                        <h2 class="product-title">
                                            <a href="<?php echo route('getProductCategory', ['id'=>$event_category->id, 'slug'=>$event_category->category_slug]); ?>"><?php echo $event_category->category_name; ?></a>
                                        </h2>
                                        <br>
                                        <a href="<?php echo route('getProductCategory', ['id'=>$event_category->id, 'slug'=>$event_category->category_slug]); ?>" class="show-more-btn">
                                            More
                                            <span class="fa fa-eye"></span>
                                        </a>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php endif; ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        </section>
    <?php endif; ?>
    <section class="container about-us text-center" id="about_us">
        <h2>About our tradition</h2>
        <div class="row">
            <div class="col-md-3">
                <div>
                    <div class="about-us-img img-thumbnail">
                        <img src="<?php echo url('images/tradicija/VaneTatko-min.jpg'); ?>" class="img-responsive">
                        <h4>Vane - the founder of Ohrid Pearls 1902-1964</h4>
                    </div>
                    <div class="about-us-img img-thumbnail">
                        <img src="<?php echo url('images/tradicija/prodazba-min.jpg'); ?>" class="img-responsive">
                        <h4>Selling Ohrid pearls in 1935</h4>
                    </div>
                    <div class="about-us-img img-thumbnail">
                        <img class="img-responsive" src="<?php echo url('images/tradicija/elizabeth.jpg'); ?>">
                        <h4>Queen Elizabeth have on Ohrid Pearls made by Talev family</h4>
                    </div>
                </div>
            </div>
            <div class="col-md-6">
                <div class="about-us-img-big img-thumbnail">
                    <img src="<?php echo url('images/tradicija/izrabotka-min.jpg'); ?>" class="img-responsive">
                    <h4>Father of Kliment, Vane at workroom in 1935</h4>
                </div>
                <div class="about-us-item">
                    <h3>Our long tradition</h3>
                    <div class="about-us-text">
                        <p>
                            <img src="<?php echo url('images/logo.png'); ?>" class="logo-about img-thumbnail">
                            Ohrid has many sights and it can not be described briefly. One of these sights is the Ohrid pearl, which is widely popular in Europe and the world. It is valued because it is handmade from natural origin. It’s production is an art. Natural pearls last 150 years, but Ohrid pearl lasts forever.
                        </p>
                        <p>
                            “Talevi”  is the  most famous family that deals with making the Ohrid pearl -a tradition of 90 years. Talevi surname is a synonym for  unique, natural pearls. The business passed from generation to generation, only from father to son.
                        </p>
                        <p>
                            Kliment Talev (pictured left) inherited the family business in 1964.Currently craft for making Ohrid pearl is teaching his son Vane (pictured right), who will then leave an inheritance to their three sons, Kliment,  Michael  and Aleksandar.
                        </p>
                        <p>
                            The family business started Vane and his brother Mihail, (father and uncle of Kliment). They purchaised the formula for making a pearls  from a man from Russia for 25 napoleons.  Mihail bought materials  for making pearls from Bethlehem and they started to work.
                        </p>
                        <p>
                            Wealthy  people began to buy from them, because only rich people could afford pearls. Into the shop came traders, bank owners, young Industrialists and bought pearls for their fiancés and wives. The pearls were named “Ohrid Pearls”. That name was established  in 1935. Traders from Bitola and Skopje were common customers and they usually were sayin that they go to Ohrid for pearls, and that is how the name “Ohrid Pearl” was created- tells Talev.
                        </p>
                        <p>
                            Ohrid pearls are highly appreciated and sought after in the world. They are made of nacre and shells, which Talevi procured from abroad. Each grain of pearl they made by hand, which issue certificates. Before starting work, Thalev  put the grains of pearl on toothpicks over wooden meter long table. Each grain is coated with special emulsion, which is a family secret.
                        </p>
                        <p>
                            We work only with natural materials. Even the brush with which we coat the pearls  is made from fibers from squirel tail or  horse. An  emulsion has the same formula that bought my father and my uncle in 1924 - said KlimentTalev.
                        </p>
                        <p>
                            Each pearl is cat five to six times, and the time from one to another coating must be at least 45 minutes to an hour, to be well dried . Talev said it is not recommended to string pearls the same day they are made, but it is best to do so the next day.
                        </p>
                        <p>
                            Many  famous people from Macedonia and abroad bought  pearls from Talevi. Some of them are: former president of Republic of Macedonia,  Branko Crvenkovski, the ambassador of China, the wife of the japanese ambassador, Deputy Prime Minister of Luxembourg, wife of the foreign Minister of Taiwan, foreign Minister of the Republic Bulgaria - N. Mikhailova, Ms. Falk Al Hassadim - the sister of king of Syria, Ms. Eveline Herfkens –  Netherlands,  Anna Lindh foreign Minister  of Sweden, Mary Thiessen - NATO Reeder - Austria and others.
                        </p>
                        <p>
                            Britain's Queen Elizabeth in her jewelry collection possesses Ohrid Pearl, which in 2001 gave it то her as a gift Vilma Trajkovska.
                        </p>
                    </div>
                    <div class="about-us-text">
                    </div>
                </div>

                <div class="about-us-item working-process text-left">
                    <h3>The working process</h3>
                    <p>The following pictures present how Kliment and Vane made Ohrid pearls by hand. The technology is old more then 90 years.</p>
                    <div class="col-sm-4 col-xs-6 item-images">
                        <div class="gallery-image-item">
                            <a class="grouped_elements" href="<?php echo URL::asset('images/raboten_proces/rab1-min.jpg'); ?>" data-fancybox="group">
                                <img src="<?php echo URL::asset('images/raboten_proces/thumb/rab1-min.jpg'); ?>" alt="" class="img-responsive img-thumbnail"/>
                            </a>
                        </div>
                    </div>
                    <div class="col-sm-4 col-xs-6 item-images">
                        <div class="gallery-image-item">
                            <a class="grouped_elements" href="<?php echo URL::asset('images/raboten_proces/rab2-min.jpg'); ?>" data-fancybox="group">
                                <img src="<?php echo URL::asset('images/raboten_proces/thumb/rab2-min.jpg'); ?>" alt="" class="img-responsive img-thumbnail"/>
                            </a>
                        </div>
                    </div>
                    <div class="col-sm-4 col-xs-6 item-images">
                        <div class="gallery-image-item">
                            <a class="grouped_elements" href="<?php echo URL::asset('images/raboten_proces/rab3-min.jpg'); ?>" data-fancybox="group">
                                <img src="<?php echo URL::asset('images/raboten_proces/thumb/rab3-min.jpg'); ?>" alt="" class="img-responsive img-thumbnail"/>
                            </a>
                        </div>
                    </div>
                    <div class="col-sm-4 col-xs-6 item-images">
                        <div class="gallery-image-item">
                            <a class="grouped_elements" href="<?php echo URL::asset('images/raboten_proces/rab4-min.jpg'); ?>" data-fancybox="group">
                                <img src="<?php echo URL::asset('images/raboten_proces/thumb/rab4-min.jpg'); ?>" alt="" class="img-responsive img-thumbnail"/>
                            </a>
                        </div>
                    </div>
                    <div class="col-sm-4 col-xs-6 item-images">
                        <div class="gallery-image-item">
                            <a class="grouped_elements" href="<?php echo URL::asset('images/raboten_proces/rab5-min.jpg'); ?>" data-fancybox="group">
                                <img src="<?php echo URL::asset('images/raboten_proces/thumb/rab5-min.jpg'); ?>" alt="" class="img-responsive img-thumbnail"/>
                            </a>
                        </div>
                    </div>
                    <div class="col-sm-4 col-xs-6 item-images">
                        <div class="gallery-image-item">
                            <a class="grouped_elements" href="<?php echo URL::asset('images/raboten_proces/rab6-min.jpg'); ?>" data-fancybox="group">
                                <img src="<?php echo URL::asset('images/raboten_proces/thumb/rab6-min.jpg'); ?>" alt="" class="img-responsive img-thumbnail"/>
                            </a>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div>
                    <div class="about-us-img img-thumbnail">
                        <img src="<?php echo url('images/sertifikati/medalG.jpg'); ?>" class="img-responsive">
                        <h4>Golden medal Eureka 2001</h4>
                        <p>In 2001 on the fair for innovations and hand made “Eureka” in Brussel, Ohrid family Talevi win gold medal for hand made of pearl in competition of 45 competitors from whole world.</p>
                    </div>
                    <div class="about-us-img img-thumbnail">
                        <img src="<?php echo url('images/sertifikati/croatiaG.jpg'); ?>" class="img-responsive">
                        <h4> Bill of debt - Croatia</h4>
                    </div>
                    <div class="about-us-img img-thumbnail">
                        <img class="img-responsive" src="<?php echo url('images/sertifikati/DiplomaEurekaG.jpg'); ?>">
                        <h4>Certificate Eureka 2001 - Brussel</h4>
                    </div>
                    <div class="about-us-img img-thumbnail">
                        <img class="img-responsive" src="<?php echo url('images/sertifikati/GeographicalG.jpg'); ?>">
                        <h4>Certificate of Ministry for economy of Macedonia </h4>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
    <script>
        var $myCarousel = $('#carousel-example-generic');
        $myCarousel.carousel();

        function doAnimations(elems) {
            var animEndEv = 'webkitAnimationEnd animationend';

            elems.each(function () {
                var $this = $(this),
                        $animationType = $this.data('animation');
                $this.addClass($animationType).one(animEndEv, function () {
                    $this.removeClass($animationType);
                });
            });
        }

        var $firstAnimatingElems = $myCarousel.find('.item:first')
                .find('[data-animation ^= "animated"]');
        doAnimations($firstAnimatingElems);
        $myCarousel.carousel('pause');
        $myCarousel.on('slide.bs.carousel', function (e) {
            // Select the elements to be animated inside the active slide
            var $animatingElems = $(e.relatedTarget)
                    .find("[data-animation ^= 'animated']");
            doAnimations($animatingElems);
        });



        var $item = $('.carousel .item');
        var $wHeight = $(window).height();
        $item.eq(0).addClass('active');
        $item.height($wHeight);
        $item.addClass('full-screen');

        $('.carousel img').each(function() {
            var $src = $(this).attr('src');
            var $color = $(this).attr('data-color');
            $(this).parent().css({
                'background-image' : 'url(' + $src + ')',
                'background-color' : $color
            });
            $(this).remove();
        });

        $(window).on('resize', function (){
            $wHeight = $(window).height();
            $item.height($wHeight);
        });

        $('.carousel').carousel({
            interval: 6000,
            pause: "false"
        });

    </script>
    <script src="<?php echo url('js/owl.carousel.min.js'); ?>"></script>
    <script>
        $('.owl-carousel').owlCarousel({
            loop:true,
            margin:0,
            autoplay: true,
            responsiveClass:true,
            navText : ["<i class='fa fa-chevron-left'></i>","<i class='fa fa-chevron-right'></i>"],
            responsive:{
                0:{
                    items:1,
                    nav:true
                },
                600:{
                    items:3,
                    nav:true
                },
                1000:{
                    items:4,
                    nav:true,
                    loop:false
                }
            }
        })
    </script>
    <script src="<?php echo url('fancybox/dist/jquery.fancybox.min.js'); ?>"></script>
    <script type="text/javascript">
        $("[data-fancybox].working-process").fancybox({
            // Options will go here

        });
    </script>

    <script>
        $(document).ready(function() {
            $("#pocetna").addClass('active');

            $('#za_nas').click(function(e){
                e.preventDefault();
                $('html, body').animate({
                    scrollTop: $('#about_us').offset().top-60
                }, 1000);
                $("#pocetna").removeClass('active');
                $("#za_nas").addClass('active');
            });

            $('#pocetna').click(function(e){
                e.preventDefault();
                $('html, body').animate({
                    scrollTop: $('body').offset().top
                }, 1000);
                $("#za_nas").removeClass('active');
                $("#pocetna").addClass('active');
            });
        });

        $(document).ready(function () {
            var hash = window.location.hash;
            if(hash=='#about-us'){
                $('html, body').animate({
                    scrollTop: $('#about_us').offset().top-80
                }, 500);
            }
        });
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layout', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>