<?php $__env->startSection('styles'); ?>
    <link rel="stylesheet" href="<?php echo URL::asset('css/admin.css'); ?>">
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="container top-margin">
        <div class="row">
            <div class="col-md-12">
                <div class="panel panel-primary top-panel-margin">
                    <div class="panel-heading"><span class="fa fa-users"></span> Регистрирани корисници</div>

                    <div class="panel-body">
                        <?php if(session('status')): ?>
                            <div class="alert <?php echo session('status-class'); ?> alert-dismissable fade in">
                                <a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>
                                <?php echo session('status'); ?>

                            </div>
                        <?php endif; ?>
                        <div class="users">
                            <table class="table">
                                <thead>
                                <th>Име</th>
                                <th>E-mail</th>
                                <th>Корисник</th>
                                <th>Едитор</th>
                                <th>Админ</th>
                                </thead>
                                <tbody>
                                <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr <?php echo $user->id==Auth::id() ? 'class="alert-info"' : ''; ?>>
                                        <form action="<?php echo route('assignRoles'); ?>" method="post">
                                            <td><?php echo $user->name; ?></td>
                                            <td><?php echo $user->email; ?><input type="hidden" name="email" value="<?php echo $user->email; ?>"></td>
                                            <td><input type="checkbox"<?php echo $user->hasRole('User') ? 'checked' : ''; ?> <?php echo $user->hasRole('User') ? 'checked' : ''; ?> name="role_user" <?php echo $user->id==Auth::id() ? 'disabled="disabled"' : ''; ?>></td>
                                            <td><input type="checkbox" <?php echo $user->hasRole('Editor') ? 'checked' : ''; ?> name="role_editor" <?php echo $user->id==Auth::id() ? 'disabled="disabled"' : ''; ?>></td>
                                            <td><input type="checkbox" <?php echo $user->hasRole('Admin') ? 'checked' : ''; ?> name="role_admin" <?php echo $user->id==Auth::id() ? 'disabled="disabled"' : ''; ?>></td>
                                            <?php echo csrf_field(); ?>

                                            <td>
                                                <button class="btn btn-primary" type="submit" <?php echo $user->id==Auth::id() ? 'disabled="disabled"' : ''; ?>>Промени</button>
                                                <a href="#" <?php echo $user->id==Auth::id() ? 'disabled="disabled"' : ''; ?> class="btn btn-danger" data-toggle="modal" data-target="#modal-delete-<?php echo $user->id; ?>"><span class="fa fa-trash-o"></span></a>
                                            </td>
                                        </form>
                                    </tr>
                                    <div class="modal fade" id="modal-delete-<?php echo $user->id; ?>">
                                        <div class="modal-dialog">
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                                                    <h4 class="modal-title">Избриши корисник</h4>
                                                </div>
                                                <div class="modal-body grey-bg">
                                                    <p>
                                                        Дали сте сигурни дека сакате да го избришете корисникот <?php echo $user->name; ?> ?<br>
                                                    </p>
                                                </div>
                                                <div class="modal-footer grey-bg">
                                                    <a href="<?php echo URL::route('deleteUser', ['id'=>$user->id]); ?>" class="btn btn-danger">Избриши&nbsp; <span class="fa fa-trash-o"></span>
                                                    </a>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layout', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>