<?php $__env->startSection('title'); ?>
    <title>Gallery - Ohrid pearls Talevi</title>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('description'); ?>
    <meta name="description" content="Our shop and our pearls">
<?php $__env->stopSection(); ?>
<?php $__env->startSection('keywords'); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('styles'); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="container-fluid galleries top-margin">
        <div class="container-fluid">
            <div class="gallery-items row">
                <?php $__currentLoopData = $galleries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $gallery): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="col-sm-3 col-xs-6 items-galleries">
                        <div class="gallery-item">
                            <a href="javascript:void(0)" onclick="openGallery(<?php echo $gallery->id; ?>)">
                                <?php $__currentLoopData = \DB::table('gallery_images')->where('gallery_id', $gallery->id)->orderBy('image_order', 'asc')->limit(1)->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $gallery_image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <img src="<?php echo URL::asset('images/galleries'); ?>/<?php echo $gallery->id; ?>/<?php echo $gallery_image->thumbnail; ?>" class="img-responsive content-image img-thumbnail">
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <div class="middle">
                                    <div class="text" id="text-<?php echo $gallery->id; ?>">
                                        <span class="fa fa-search fa-2x"></span><br>
                                        Open
                                    </div>
                                </div>
                            </a>
                        </div>
                        <h3><?php echo $gallery->gallery_name; ?></h3>
                        <?php if(Auth::user()): ?>
                            <?php if(Auth::user()->hasRole('admin')||Auth::user()->hasRole('editor')): ?>
                                <div class="edit_gallery_page">
                                    <a href="<?php echo route('removeGalleryPage', ['gallery_id'=>$gallery->id, 'page_id'=>1]); ?>" class="btn btn-default btn-xs"><span class="fa fa-remove"></span></a>
                                    <a href="<?php echo route('getEditGallery', ['id'=>$gallery->id]); ?>" class="btn btn-default btn-xs"><span class="fa fa-pencil"></span></a>
                                </div>
                            <?php endif; ?>
                        <?php endif; ?>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
    <script>
        function openGallery(gallery_id)
        {
            $('#text-'+gallery_id).html('<span class="fa fa-spinner fa-spin fa-2x"></span><br>Open');
            $.ajax({
                url: 'gallery/'+gallery_id+'/images',
                dataType: 'json'
            }).done(function (data) {
                $('#text-'+gallery_id).html('<span class="fa fa-search fa-2x"></span><br>Open');
                $('.gallery-items').fadeOut(function () {
                    $("body").scrollTop();
                    $('.gallery-items').html(data).fadeIn();
                });
            }).fail(function () {
                alert('Images could not be loaded.');
            });
        }
    </script>
    <script>
        $(document).ready(function() {
            $("#galerija").addClass('active');
        });

        $('#za_nas').click(function(){
            window.location.href ='<?php echo route('getHome'); ?>#about-us';
        });
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layout', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>