<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/', [
    'as'=>'getHome',
    'uses'=>'HomeController@index'
]);

Route::get('/ohrid-pearls', [
    'as'=>'getProducts',
    'uses'=>'HomeController@getProducts'
]);
Route::get('/ohrid-pearls/{id}/{slug}', [
    'as'=>'getProductCategory',
    'uses'=>'HomeController@getProductCategory'
]);

Route::get('/ohrid-pearl/{id}', [
    'as'=>'getProduct',
    'uses'=>'HomeController@getProduct'
]);


Route::get('/ohrid-pearls-talevi', [
    'as'=>'getGalleries',
    'uses'=>'HomeController@getGalleries'
]);

Route::get('/gallery/{id}/images', [
    'as'=>'getGalleryImages',
    'uses'=>'HomeController@getGalleryImages'
]);

Route::get('/contact-and-buy-ohrid-pearls', [
    'as'=>'getContact',
    'uses'=>'HomeController@getContact'
]);

//Send contact message
Route::post('/send-message', [
    'as' => 'sendMessage',
    'uses' => 'HomeController@sendMessage'
]);


/*
 * Auth routes
 */
Auth::routes();

/*
 * User routes
 */
Route::get('/dashboard/users', [
    'as'=>'getUsers',
    'uses'=>'DashboardController@getUsers',
    'middleware'=>'roles',
    'roles'=>['admin']
]);

Route::post('/dashboard/users/assign-roles', [
    'as' => 'assignRoles',
    'uses' => 'DashboardController@assignRoles',
    'middleware'=>'roles',
    'roles'=>['admin']
]);


/*
 * Gallery routes
 */
Route::get('/dashboard/gallery', [
    'as'=>'getGallery',
    'uses'=>'DashboardController@getGallery',
    'middleware'=>'roles',
    'roles'=>['admin', 'editor']
]);

Route::get('/dashboard/video', [
    'as'=>'getVideo',
    'uses'=>'DashboardController@getVideo',
    'middleware'=>'roles',
    'roles'=>['admin', 'editor']
]);

Route::get('/dashboard/event', [
    'as'=>'getEventAdmin',
    'uses'=>'DashboardController@getEventAdmin',
    'middleware'=>'roles',
    'roles'=>['admin', 'editor']
]);

Route::get('/dashboard/gallery/back', [
    'as'=>'getGalleryBack',
    'uses'=>'DashboardController@getGalleryBack',
    'middleware'=>'roles',
    'roles'=>['admin', 'editor']
]);

Route::post('/dashboard/create-gallery/first-step', [
    'as'=>'createGalleryFirst',
    'uses'=>'DashboardController@createGalleryFirst',
    'middleware'=>'roles',
    'roles'=>['admin', 'editor']
]);

Route::post('/dashboard/create-gallery/second-step', [
    'as'=>'createGallerySecond',
    'uses'=>'DashboardController@createGallerySecond',
    'middleware'=>'roles',
    'roles'=>['admin', 'editor']
]);

Route::get('/dashboard/galleries', [
    'as'=>'getGalleriesAdmin',
    'uses'=>'DashboardController@getGalleriesAdmin',
    'middleware'=>'roles',
    'roles'=>['admin', 'editor']
]);

Route::get('/dashboard/gallery/{id}', [
    'as'=>'getEditGallery',
    'uses'=>'DashboardController@getEditGallery',
    'middleware'=>'roles',
    'roles'=>['admin', 'editor']
]);

Route::get('/dashboard/gallery/{id}/delete', [
    'as'=>'deleteGallery',
    'uses'=>'DashboardController@deleteGallery',
    'middleware'=>'roles',
    'roles'=>['admin', 'editor']
]);

Route::get('/dashboard/gallery/image/{id}/delete', [
    'as'=>'deleteGalleryImage',
    'uses'=>'DashboardController@deleteGalleryImage',
    'middleware'=>'roles',
    'roles'=>['admin', 'editor']
]);

Route::get('/dashboard/gallery/image/{gallery_id}/upload', [
    'as'=>'uploadNewImages',
    'uses'=>'DashboardController@uploadNewImages',
    'middleware'=>'roles',
    'roles'=>['admin', 'editor']
]);

Route::post('/dashboard/{id}/update-gallery', [
    'as'=>'updateGalleryInfo',
    'uses'=>'DashboardController@updateGalleryInfo',
    'middleware'=>'roles',
    'roles'=>['admin', 'editor']
]);

Route::post('/dashboard/image/{id}/update-info', [
    'as'=>'updateImageDescriptionAlt',
    'uses'=>'DashboardController@updateImageDescriptionAlt',
    'middleware'=>'roles',
    'roles'=>['admin', 'editor']
]);

Route::get('/dashboard/image/{id}/crop', [
    'as'=>'getCropImage',
    'uses'=>'DashboardController@getCropImage',
    'middleware'=>'roles',
    'roles'=>['admin', 'editor']
]);

Route::post('/dashboard/image/{id}/crop', [
    'as'=>'postCropImage',
    'uses'=>'DashboardController@postCropImage',
    'middleware'=>'roles',
    'roles'=>['admin', 'editor']
]);

Route::post('/dashboard/thumbnail/{id}/crop', [
    'as'=>'postCropThumbnail',
    'uses'=>'DashboardController@postCropThumbnail',
    'middleware'=>'roles',
    'roles'=>['admin', 'editor']
]);

Route::post('/dashboard/gallery/{gallery_id}/add-to-page', [
    'as'=>'addGalleryToPage',
    'uses'=>'DashboardController@addGalleryToPage',
    'middleware'=>'roles',
    'roles'=>['admin', 'editor']
]);

Route::post('/dashboard/gallery/{gallery_id}/add-to-event', [
    'as'=>'addGalleryToEvent',
    'uses'=>'DashboardController@addGalleryToEvent',
    'middleware'=>'roles',
    'roles'=>['admin', 'editor']
]);

Route::post('/dashboard/create-event', [
    'as'=>'createEvent',
    'uses'=>'DashboardController@createEvent',
    'middleware'=>'roles',
    'roles'=>['admin', 'editor']
]);

Route::get('/dashboard/events', [
    'as'=>'getEventsAdmin',
    'uses'=>'DashboardController@getEventsAdmin',
    'middleware'=>'roles',
    'roles'=>['admin', 'editor']
]);

Route::get('/dashboard/event/{id}', [
    'as'=>'getEditEvent',
    'uses'=>'DashboardController@getEditEvent',
    'middleware'=>'roles',
    'roles'=>['admin', 'editor']
]);

Route::get('/dashboard/event/remove-gallery/{gallery_id}/{event_id}', [
    'as'=>'removeGalleryEvent',
    'uses'=>'DashboardController@removeGalleryEvent',
    'middleware'=>'roles',
    'roles'=>['admin', 'editor']
]);

Route::post('/dashboard/event/{event_id}/add-to-gallery', [
    'as'=>'addEventToGallery',
    'uses'=>'DashboardController@addEventToGallery',
    'middleware'=>'roles',
    'roles'=>['admin', 'editor']
]);

Route::get('/dashboard/event/{id}/delete-event', [
    'as'=>'deleteEvent',
    'uses'=>'DashboardController@deleteEvent',
    'middleware'=>'roles',
    'roles'=>['admin', 'editor']
]);

Route::get('/dashboard/event/{id}/make-visible', [
    'as'=>'makeEventVisible',
    'uses'=>'DashboardController@makeEventVisible',
    'middleware'=>'roles',
    'roles'=>['admin', 'editor']
]);

Route::get('/dashboard/event/{id}/make-hidden', [
    'as'=>'makeEventHidden',
    'uses'=>'DashboardController@makeEventHidden',
    'middleware'=>'roles',
    'roles'=>['admin', 'editor']
]);

Route::post('/dashboard/event/{id}/update', [
    'as'=>'updateEvent',
    'uses'=>'DashboardController@updateEvent',
    'middleware'=>'roles',
    'roles'=>['admin', 'editor']
]);

Route::get('/dashboard/event/{id}/all-galleries', [
    'as'=>'getAllGalleriesEvent',
    'uses'=>'DashboardController@getAllGalleriesEvent',
    'middleware'=>'roles',
    'roles'=>['admin', 'editor']
]);

Route::get('/dashboard/event/{gallery_id}/{event_id}/all-galleries/add-to-gallery', [
    'as'=>'addEventToGalleryAll',
    'uses'=>'DashboardController@addEventToGalleryAll',
    'middleware'=>'roles',
    'roles'=>['admin', 'editor']
]);

Route::get('/dashboard/page/remove-gallery/{gallery_id}/{page_id}', [
    'as'=>'removeGalleryPage',
    'uses'=>'DashboardController@removeGalleryPage',
    'middleware'=>'roles',
    'roles'=>['admin', 'editor']
]);

Route::get('/dashboard/videos', [
    'as'=>'getVideosAdmin',
    'uses'=>'DashboardController@getVideosAdmin',
    'middleware'=>'roles',
    'roles'=>['admin', 'editor']
]);

Route::post('/dashboard/create-video/first-step', [
    'as'=>'createVideoFirst',
    'uses'=>'DashboardController@createVideoFirst',
    'middleware'=>'roles',
    'roles'=>['admin', 'editor']
]);

Route::get('/dashboard/video/{id}', [
    'as'=>'getEditVideo',
    'uses'=>'DashboardController@getEditVideo',
    'middleware'=>'roles',
    'roles'=>['admin', 'editor']
]);

Route::get('/dashboard/video/{id}/delete', [
    'as'=>'deleteVideo',
    'uses'=>'DashboardController@deleteVideo',
    'middleware'=>'roles',
    'roles'=>['admin', 'editor']
]);

Route::post('/dashboard/{id}/update-video', [
    'as'=>'updateVideoInfo',
    'uses'=>'DashboardController@updateVideoInfo',
    'middleware'=>'roles',
    'roles'=>['admin', 'editor']
]);

Route::post('/dashboard/video/{video_id}/add-to-event', [
    'as'=>'addVideoToEvent',
    'uses'=>'DashboardController@addVideoToEvent',
    'middleware'=>'roles',
    'roles'=>['admin', 'editor']
]);



Route::get('/dashboard/event/remove-video/{video_id}/{event_id}', [
    'as'=>'removeVideoEvent',
    'uses'=>'DashboardController@removeVideoEvent',
    'middleware'=>'roles',
    'roles'=>['admin', 'editor']
]);


Route::post('/dashboard/event/{event_id}/add-to-video', [
    'as'=>'addEventToVideo',
    'uses'=>'DashboardController@addEventToVideo',
    'middleware'=>'roles',
    'roles'=>['admin', 'editor']
]);

Route::get('/dashboard/event/{id}/all-videos', [
    'as'=>'getAllVideosEvent',
    'uses'=>'DashboardController@getAllVideosEvent',
    'middleware'=>'roles',
    'roles'=>['admin', 'editor']
]);


Route::get('/dashboard/event/{video_id}/{event_id}/all-videos/add-to-video', [
    'as'=>'addEventToVideoAll',
    'uses'=>'DashboardController@addEventToVideoAll',
    'middleware'=>'roles',
    'roles'=>['admin', 'editor']
]);

Route::get('/dashboard/delete/user/{id}', [
    'as'=>'deleteUser',
    'uses'=>'DashboardController@deleteUser',
    'middleware'=>'roles',
    'roles'=>['admin']
]);

Route::get('/dashboard/gallery_images/{ids}/change/order', [
    'as'=>'changeGalleryImageOrder',
    'uses'=>'DashboardController@changeGalleryImageOrder',
    'middleware'=>'roles',
    'roles'=>['admin', 'editor']
]);

Route::get('/dashboard/reorder/gallery/{id}', [
    'as'=>'getSortable',
    'uses'=>'DashboardController@getSortable',
    'middleware'=>'roles',
    'roles'=>['admin', 'editor']
]);

Route::get('/dashboard/reorder/page-galleries', [
    'as'=>'getPageGalleries',
    'uses'=>'DashboardController@getPageGalleries',
    'middleware'=>'roles',
    'roles'=>['admin', 'editor']
]);

Route::get('/dashboard/galleries/{ids}/change/order', [
    'as'=>'changeGalleryOrder',
    'uses'=>'DashboardController@changeGalleryOrder',
    'middleware'=>'roles',
    'roles'=>['admin', 'editor']
]);

Route::post('/dashboard/event/category/add_new', [
    'as'=>'addNewCategory',
    'uses'=>'DashboardController@addNewCategory',
    'middleware'=>'roles',
    'roles'=>['admin', 'editor']
]);

Route::post('/dashboard/event/category/add_new', [
    'as'=>'addNewCategory',
    'uses'=>'DashboardController@addNewCategory',
    'middleware'=>'roles',
    'roles'=>['admin', 'editor']
]);

Route::post('/dashboard/event/categories/edit/{id}', [
    'as'=>'editCategory',
    'uses'=>'DashboardController@editCategory',
    'middleware'=>'roles',
    'roles'=>['admin', 'editor']
]);

Route::get('/dashboard/event/categories/delete/{id}', [
    'as'=>'deleteCategory',
    'uses'=>'DashboardController@deleteCategory',
    'middleware'=>'roles',
    'roles'=>['admin', 'editor']
]);