@extends('layout')
@section('styles')
    <link rel="stylesheet" href="{!! URL::asset('css/admin.css') !!}">
    <style>

    </style>
@endsection
@section('content')
    <div class="container top-margin">
        <div class="row">
            <div class="col-md-12">
                <div class="panel panel-primary top-panel-margin">
                    <div class="panel-heading"><span class="fa fa-youtube"></span> Youtube видеа
                        <a href="{!! route('getVideo') !!}" class="btn btn-sm btn-success" style="float:right; margin-right: 3px;">
                            <span class="fa fa-plus"></span>
                        </a>
                    </div>

                    <div class="panel-body">
                        @if(session('status'))
                            <div class="alert {!! session('status-class') !!} alert-dismissable fade in">
                                <a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>
                                {!! session('status') !!}
                            </div>
                        @endif
                        <div class="gallery_items">
                            @foreach($videos as $video)
                                <div class="col-md-3 col-sm-6 text-center gallery_item_wrap">
                                    <div class="gallery_item">
                                        <iframe width="100%" height="300" src="https://www.youtube.com/embed/{!! $video->video_code !!}" frameborder="0" allowfullscreen></iframe>
                                        <h4>{!! $video->video_name !!}</h4>
                                        <p>{!! $video->video_description !!}</p>
                                        <a href="{!! route('getEditVideo', ['id'=>$video->id]) !!}" class="btn btn-primary btn-sm">
                                            ЕДИТИРАЈ
                                            <span class="fa fa-pencil"></span>
                                        </a>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                        <div class="row text-center">
                            {{ $videos->links() }}
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('scripts')
    <script>
        var divs = $(".gallery_item_wrap");
        var i=0;

        if ($(window).width() >= 992) {
            for(i = 0; i < divs.length; i+=4) {
                divs.slice(i, i+4).wrapAll("<div class='row'></div>");
            }
        }

        else
        {
            for (i = 0; i < divs.length; i += 2) {
                divs.slice(i, i + 2).wrapAll("<div class='row'></div>");
            }
        }

    </script>

    <script>
        $('#za_nas').click(function(){
            window.location.href ='{!! route('getHome') !!}#about-us';
        });
    </script>
@endsection
