@extends('layout')
@section('styles')
    <link rel="stylesheet" href="{!! URL::asset('css/admin.css') !!}">
    <link rel="stylesheet" href="//code.jquery.com/ui/1.12.1/themes/base/jquery-ui.css">
    <script src="{!! URL::asset('ckeditor/ckeditor.js') !!}"></script>
@endsection
@section('content')
    <div class="container top-margin">
        <div class="row">
            <div class="col-md-12">
                <div class="panel panel-primary top-panel-margin">
                    <div class="panel-heading"><span class="fa fa-image"></span> Сите албуми
                        <a href="{!! route('getEditEvent',['id'=>$id]) !!}" class="btn btn-sm btn-primary" style="float:right; margin-right:2px;">
                            <span class="fa fa-arrow-left"></span>
                            Производ
                        </a>
                    </div>

                    <div class="panel-body">
                        @if(session('status'))
                            <div class="alert {!! session('status-class') !!} alert-dismissable fade in">
                                <a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>
                                {!! session('status') !!}
                            </div>
                        @endif
                            <div class="form-group">
                                @foreach($galleries as $event_gallery)
                                    <div class="col-md-3 text-center" id="gallery-item-{!! $event_gallery->id !!}">
                                        <div class="gallery_item {!! App\Event::find($id)->galleries()->where('gallery_id', $event_gallery->id)->exists() ? 'alert-success' : 'alert-danger' !!}">
                                            @if(\DB::table('gallery_images')->where('gallery_id', $event_gallery->id)->count()==0)
                                                <a href="{!! route('uploadNewImages',['gallery_id'=>$event_gallery->id]) !!}">
                                                    <img src="{!! URL::asset('images/image_placeholder_g.jpg')!!}" class="img-responsive img-thumbnail">
                                                </a>
                                            @else
                                                @foreach(\DB::table('gallery_images')->where('gallery_id', $event_gallery->id)->orderBy('id', 'desc')->limit(1)->get() as $gallery_image)
                                                    <img src="{!! URL::asset('images/galleries') !!}/{!! $event_gallery->id !!}/{!! $gallery_image->thumbnail !!}" class="img-responsive img-thumbnail">
                                                @endforeach
                                            @endif
                                            <h4>{!! $event_gallery->gallery_name !!}</h4>
                                            <p>{!! $event_gallery->gallery_description !!}</p>
                                            <a href="{!! route('getEditGallery', ['id'=>$event_gallery->id]) !!}" class="btn btn-primary btn-sm">
                                                ЕДИТИРАЈ
                                                <span class="fa fa-pencil"></span>
                                            </a>
                                            @if(App\Event::find($id)->galleries()->where('gallery_id', $event_gallery->id)->exists())
                                                    <a href="{!! route('removeGalleryEvent', ['gallery_id'=>$event_gallery->id, 'event_id'=>$id]) !!}" class="btn btn-danger btn-sm">
                                                        ОТСТРАНИ
                                                        <span class="fa fa-remove"></span>
                                                    </a>
                                                @else
                                                    <a href="{!! route('addEventToGalleryAll', ['gallery_id'=>$event_gallery->id, 'event_id'=>$id]) !!}" class="btn btn-success btn-sm">
                                                        ДОДАДИ
                                                        <span class="fa fa-check"></span>
                                                    </a>
                                            @endif
                                        </div>
                                    </div>
                                @endforeach
                                <div class="col-md-12 text-center">
                                    {!! $galleries->links() !!}
                                </div>
                            </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('scripts')
    <script>
        $('#za_nas').click(function(){
            window.location.href ='{!! route('getHome') !!}#about-us';
        });
    </script>
@endsection
