@extends('layout')
@section('styles')
    <link rel="stylesheet" href="{!! URL::asset('css/admin.css') !!}">
    <link rel="stylesheet" href="//code.jquery.com/ui/1.12.1/themes/base/jquery-ui.css">
    <script src="{!! URL::asset('ckeditor/ckeditor.js') !!}"></script>
@endsection
@section('content')
    <div class="container top-margin">
        <div class="row">
            <div class="col-md-12">
                <div class="panel panel-primary top-panel-margin">
                    <div class="panel-heading">
                        <span class="fa fa-calendar-plus-o"></span> Ажурирај производ

                        <a href="" class="btn btn-sm btn-danger" style="float:right" data-toggle="modal" data-target="#modal-delete-{!! $event->id !!}">
                            <span class="fa fa-trash-o"></span>
                        </a>
                        <div class="modal fade" id="modal-delete-{!! $event->id !!}">
                            <div class="modal-dialog">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <button type="button" class="close" data-dismiss="modal">&times;</button>
                                        <h4 class="modal-title">Избриши производ</h4>
                                    </div>
                                    <div class="modal-body grey-bg">
                                        <p>
                                            Дали сте сигурни дека сакате да го избришете производот "{!! $event->event_title !!}"?<br>
                                        </p>
                                    </div>
                                    <div class="modal-footer grey-bg">
                                        <a href="{!! URL::route('deleteEvent', ['id'=>$event->id])!!}" class="btn btn-danger">Избриши&nbsp; <span class="fa fa-trash-o"></span>
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>

                        @if(\DB::table('events')->find($event->id)->is_shown==0)
                            <a href="{!! route('makeEventVisible', ['id'=>$event->id]) !!}" class="btn btn-sm btn-danger" style="float:right; margin-right:2px;">
                                <span class="fa fa-eye"></span>
                            </a>
                        @else
                            <a href="{!! route('makeEventHidden', ['id'=>$event->id]) !!}" class="btn btn-sm btn-success" style="float:right; margin-right:2px;">
                                <span class="fa fa-eye"></span>
                            </a>
                        @endif

                        <a href="{!! route('getEventsAdmin') !!}" class="btn btn-sm btn-primary" style="float:right; margin-right:2px;">
                            <span class="fa fa-arrow-left"></span>
                            Производи
                        </a>

                    </div>

                    <div class="panel-body">
                        <div class="alert" style="display: none" id="status_message">
                            <div id="errors_title" style="display: none"></div>
                            <div id="errors_description" style="display: none"></div>
                            <div id="errors_category" style="display: none"></div>
                            <div id="errors_content" style="display: none"></div>
                            <div id="errors_size" style="display: none"></div>
                            <div id="errors_color" style="display: none"></div>
                            <div id="errors_mechanism" style="display: none"></div>
                            <div id="errors_code" style="display: none"></div>
                            <div id="errors_price_from" style="display: none"></div>
                            <div id="errors_price_to" style="display: none"></div>
                            <div id="errors_price" style="display: none"></div>
                        </div>
                        @if(session('status'))
                            <div class="alert {!! session('status-class') !!} alert-dismissable fade in">
                                <a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>
                                {!! session('status') !!}
                            </div>
                        @endif
                        <div class="col-md-12">
                            <form class="form-horizontal" role="form" method="POST" action="{!! route('updateEvent', ['id'=>$event->id]) !!}" novalidate id="update_event_form">
                                {{ csrf_field() }}
                                <div class="form-group col-md-12">
                                    <div class="col-md-4">
                                        <label for="title">Име на производ</label>
                                        <input id="title" type="text" class="form-control" name="title" value="{{ $event->event_title }}">
                                    </div>

                                    <div class="col-md-2">
                                        <label for="code">Код на производ</label>
                                        <input id="code" type="text" class="form-control" name="code" value="{{ $event->code }}">
                                    </div>

                                    <div class="col-md-6">
                                        <label for="category">Тип на производ</label>
                                        <select name="category" id="category" class="form-control">
                                            @foreach(\DB::table('event_categories')->orderBy('id', 'desc')->get() as $event_category)
                                                <option value="{!! $event_category->id !!}">{!! $event_category->category_name !!}</option>
                                            @endforeach
                                        </select>

                                    </div>

                                    <div class="col-md-12">
                                        <label for="description">Опис на производот</label>
                                        <textarea id="description" class="form-control" name="description">{!!$event->event_description !!}</textarea>
                                    </div>
                                    <div class="col-md-4">
                                        <label for="size">Големина</label>
                                        <input id="size" type="text" class="form-control" name="size" value="{!!$event->size !!}">
                                    </div>
                                    <div class="col-md-4">
                                        <label for="color">Боја</label>
                                        <input id="color" type="text" class="form-control" name="color" value="{!!$event->color !!}">
                                    </div>
                                    <div class="col-md-4">
                                        <label for="mechanism">Механизам</label>
                                        <input id="mechanism" type="text" class="form-control" name="mechanism" value="{!!$event->mechanism !!}">
                                    </div>
                                    <div class="col-md-4">
                                        <label for="price" style="width: 100%">Цена</label>
                                        <div class="input_fields_wrap">
                                            @for($i=0; $i<count($event_prices); $i++)
                                            <div style="float: left; width:100%; margin-top:5px;">
                                                <input type="text" style="width:85%; float: left" class="form-control price" name="price[]" value="{!! $event_prices[$i] !!}">
                                                @if($i==0)
                                                    <a href="" id="add_field_button" class="btn btn-success " style="float: left; margin-left: 5px;"><span class="fa fa-plus"> </span></a>
                                                @elseif($i>0)
                                                    <a href="#" style="float:left; margin-left:5px;" id="remove_field" class="btn btn-danger"><span class="fa fa-remove"></span></a><br>
                                                @endif
                                            </div>
                                            @endfor
                                        </div>
                                    </div>
                                    <div class="col-md-2">
                                        <label for="price_from" style="width: 100%">Цена</label>
                                        <input id="price_from" type="text" style="width:47%; float: left" class="form-control" name="price_from" placeholder="Од..." value="{!!$event->price_from !!}">
                                        <input id="price_to" type="text" style="width:47%; float: left; margin-left: 5px;" class="form-control" name="price_to" placeholder="До..." value="{!!$event->price_to !!}">
                                    </div>
                                    <div class="col-md-2">
                                        <label for="currency">Валута</label>
                                        <select name="currency" id="currency" class="form-control">
                                            <option value="denar" {!! $event->currency=='Ден.' ? 'selected' : '' !!}>Ден.</option>
                                            <option value="euro" {!! $event->currency=='&euro;' ? 'selected' : '' !!}>&euro;</option>
                                            <option value="dolar" {!! $event->currency=='$' ? 'selected' : '' !!}>$</option>
                                        </select>
                                        <span class="help-block" id="currency_message" style="display: none;"></span>
                                    </div>
                                    <div class="col-md-2">
                                        <label for="weight">Тежина</label>
                                        <select name="weight" id="weight" class="form-control">
                                            <option value="none" {!! $event->weight==null ? 'selected' : '' !!}>-</option>
                                            <option value="gr" {!! $event->weight=='/gr' ? 'selected' : '' !!}>/gr</option>
                                        </select>
                                        <span class="help-block" id="currency_message" style="display: none;"></span>
                                    </div>
                                    <div class="col-md-12">
                                        <label for="mytextarea">Содржина</label>
                                        <textarea id="mytextarea" name="content">{!!$event->event_text !!}</textarea>
                                    </div>
                                </div>


                                <div class="col-md-12">
                                    <button type="submit" class="btn btn-success" style="float:left;">
                                        ЗАЧУВАЈ
                                        <i class="fa fa-save" aria-hidden="true"></i>
                                    </button> &nbsp;
                                    <div style="display: none; float:left; margin-top: -17px; margin-right: 30px" id="create_event_loader">
                                        <br>
                                        <span class="fa fa-spinner fa-spin fa-2x fa-fw"></span>
                                    </div>
                                </div>
                            </form>

                            <div class="form-group">
                                <div class="col-md-12"><hr>
                                    <h5><span class="fa fa-image"></span> Додади албуми</h5>
                                </div>
                                <form action="{!! route('addEventToGallery', ['event_id'=>$event->id]) !!}" method="post" novalidate>
                                    <div class="col-md-9">
                                        {!! csrf_field() !!}
                                        <select name="gallery" id="gallery" class="form-control">
                                            @foreach(App\Gallery::orderBy('id', 'desc')->limit(15)->get() as $gallery)
                                                <option value="{!! $gallery->id !!}" {!! App\Event::find($event->id)->galleries()->where('gallery_id', $gallery->id)->exists() ? 'disabled' : '' !!}>{!! $gallery->gallery_name !!}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                    <div class="col-md-3">
                                        <button class="btn btn-sm btn-success" type="submit">
                                            ДОДАДИ &nbsp;
                                            <span class="fa fa-save"> </span>
                                        </button>
                                        <a class="btn btn-sm btn-primary" href="{!! route('getAllGalleriesEvent' ,['id'=>$event->id]) !!}">
                                            СИТЕ АЛБУМИ &nbsp;
                                            <span class="fa fa-image"> </span>
                                        </a>
                                    </div>
                                </form>
                            </div>
                                @if(\DB::table('gallery_event')->where('event_id', $event->id)->count()>0)
                                    <div class="col-md-12"><hr>
                                        <h5><span class="fa fa-image"></span> Додадени албуми</h5>
                                    </div>
                                    @foreach($galleries=App\Event::find($event->id)->galleries()->get() as $event_gallery)
                                    <div class="col-md-3 text-center" id="gallery-item-{!! $event_gallery->id !!}">
                                        <div class="gallery_item">
                                            @if(\DB::table('gallery_images')->where('gallery_id', $event_gallery->id)->count()==0)
                                                <a href="{!! route('uploadNewImages',['gallery_id'=>$event_gallery->id]) !!}">
                                                    <img src="{!! URL::asset('images/image_placeholder_g.jpg')!!}" class="img-responsive img-thumbnail">
                                                </a>
                                            @else
                                                @foreach(\DB::table('gallery_images')->where('gallery_id', $event_gallery->id)->orderBy('id', 'desc')->limit(1)->get() as $gallery_image)
                                                    <img src="{!! URL::asset('images/galleries') !!}/{!! $event_gallery->id !!}/{!! $gallery_image->thumbnail !!}" class="img-responsive img-thumbnail">
                                                @endforeach
                                            @endif
                                                <h4>{!! $event_gallery->gallery_name !!}</h4>
                                                <p>{!! $event_gallery->gallery_description !!}</p>
                                                <a href="{!! route('getEditGallery', ['id'=>$event_gallery->id]) !!}" class="btn btn-primary btn-sm">
                                                    ЕДИТИРАЈ
                                                    <span class="fa fa-pencil"></span>
                                                </a>
                                                <a href="{!! route('removeGalleryEvent', ['gallery_id'=>$event_gallery->id, 'event_id'=>$event->id]) !!}" class="btn btn-danger btn-sm">
                                                    <span class="fa fa-remove"></span>
                                                </a>
                                        </div>
                                    </div>
                                    @endforeach
                                @endif


                            <!--video--->
                            <div class="form-group">
                                <div class="col-md-12"><hr>
                                    <h5><span class="fa fa-youtube"></span> Додади видеа</h5>
                                </div>
                                <form action="{!! route('addEventToVideo', ['event_id'=>$event->id]) !!}" method="post" novalidate>
                                    <div class="col-md-9">
                                        {!! csrf_field() !!}
                                        <select name="video" id="video" class="form-control">
                                            @foreach(App\Video::orderBy('id', 'desc')->limit(15)->get() as $video)
                                                <option value="{!! $video->id !!}" {!! App\Event::find($event->id)->videos()->where('video_id', $video->id)->exists() ? 'disabled' : '' !!}>{!! $video->video_name !!}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                    <div class="col-md-3">
                                        <button class="btn btn-sm btn-success" type="submit">
                                            ДОДАДИ &nbsp;
                                            <span class="fa fa-save"> </span>
                                        </button>
                                        <a class="btn btn-sm btn-primary" href="{!! route('getAllVideosEvent' ,['id'=>$event->id]) !!}">
                                            СИТЕ ВИДЕА &nbsp;
                                            <span class="fa fa-youtube"> </span>
                                        </a>
                                    </div>
                                </form>
                            </div>
                            @if(\DB::table('video_event')->where('event_id', $event->id)->count()>0)
                                <div class="col-md-12"><hr>
                                    <h5><span class="fa fa-youtube-play"></span> Додадени видеа</h5>
                                </div>
                                @foreach($videos=App\Event::find($event->id)->videos()->get() as $event_video)
                                    <div class="col-md-3 text-center" id="video-item-{!! $event_video->id !!}">
                                        <div class="gallery_item">
                                            <iframe width="100%" height="300" src="https://www.youtube.com/embed/{!! $event_video->video_code !!}" frameborder="0" allowfullscreen></iframe>
                                            <h4>{!! $event_video->video_name !!}</h4>
                                            <p>{!! $event_video->video_description !!}</p>
                                            <a href="{!! route('getEditVideo', ['id'=>$event_video->id]) !!}" class="btn btn-primary btn-sm">
                                                ЕДИТИРАЈ
                                                <span class="fa fa-pencil"></span>
                                            </a>
                                            <a href="{!! route('removeVideoEvent', ['video_id'=>$event_video->id, 'event_id'=>$event->id]) !!}" class="btn btn-danger btn-sm">
                                                <span class="fa fa-remove"></span>
                                            </a>
                                        </div>
                                    </div>
                            @endforeach
                        @endif
                            <!---video end-->
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('scripts')
    <script>
        $("#category").val('{!! $event->category_id !!}');
        CKEDITOR.replace( 'mytextarea' );
    </script>
    <script>
        $(document).ready(function() {
            var max_fields      = 10; //maximum input boxes allowed
            var wrapper         = $(".input_fields_wrap"); //Fields wrapper
            var add_button      = $("#add_field_button"); //Add button ID

            var x = 1; //initlal text box count
            $(add_button).click(function(e){ //on add input button click
                e.preventDefault();
                if(x < max_fields){ //max input box allowed
                    x++; //text box increment
                    $(wrapper).append(
                            '<div>'+
                            '<div style="float: left; width:85%; margin-top:5px;"><input type="text" style="width:100%;" class="form-control price" name="price[]"></div>'+
                            '<a href="#" style="float:left; margin-left:5px; margin-top:5px;" id="remove_field" class="btn btn-danger"><span class="fa fa-remove"></span></a><br>' +
                            '</div>'
                    );
                }
            });

            $(wrapper).on("click","#remove_field", function(e){ //user click on remove text
                e.preventDefault(); $(this).parent('div').remove(); x--;
            })
        });
    </script>
    <script>
        /*update event */
        $(document).ready(function() {
            $("#update_event_form").submit(function (a) {
                a.preventDefault();
                for ( instance in CKEDITOR.instances )
                    CKEDITOR.instances[instance].updateElement();

                var url = $("#update_event_form").attr("action");
                var data = $("#update_event_form").serializeArray();
                $("#create_event_loader").fadeIn();
                $.ajax({
                    url: url,
                    type: "post",
                    data: data,
                    dataType: "json",
                    cache: !1,
                    success: function (data) {
                        $("#create_event_loader").fadeOut();
                        if(data.product_validator=='fail_validator')
                        {
                            if(data.product_title!=''){
                                $('#title').addClass('alert-danger');
                                $('#errors_title').text(data.product_title).fadeIn();
                            }
                            else{
                                $('#title').removeClass('alert-danger');
                                $('#errors_title').fadeOut();
                            }

                            if(data.product_price!=''){
                                $('.price').addClass('alert-danger');
                                $('#errors_price').text(data.product_price).fadeIn();
                            }
                            else{
                                $('.price').removeClass('alert-danger');
                                $('#errors_price').fadeOut();
                            }

                            if(data.product_description!=''){
                                $('#description').addClass('alert-danger');
                                $('#errors_descritpion').text(data.product_description).fadeIn();
                            }
                            else{
                                $('#description').removeClass('alert-danger');
                                $('#errors_description').fadeOut();
                            }
                            if(data.product_category!=''){
                                $('#category').addClass('alert-danger');
                                $('#errors_category').text(data.product_category).fadeIn();
                            }
                            else{
                                $('#category').removeClass('alert-danger');
                                $('#errors_category').fadeOut();
                            }

                            if(data.product_content!=''){
                                $('#content').addClass('alert-danger');
                                $('#errors_content').text(data.product_content).fadeIn();
                            }
                            else{
                                $('#content').removeClass('alert-danger');
                                $('#errors_content').fadeOut();
                            }

                            if(data.product_size!=''){
                                $('#size').addClass('alert-danger');
                                $('#errors_size').text(data.product_size).fadeIn();
                            }
                            else{
                                $('#size').removeClass('alert-danger');
                                $('#errors_size').fadeOut();
                            }

                            if(data.product_color!=''){
                                $('#color').addClass('alert-danger');
                                $('#errors_color').text(data.product_color).fadeIn();
                            }
                            else{
                                $('#color').removeClass('alert-danger');
                                $('#errors_color').fadeOut();
                            }

                            if(data.product_mechanism!=''){
                                $('#mechanism').addClass('alert-danger');
                                $('#errors_mechanism').text(data.product_mechanism).fadeIn();
                            }
                            else{
                                $('#mechanism').removeClass('alert-danger');
                                $('#errors_mechanism').fadeOut();
                            }

                            if(data.product_code!=''){
                                $('#code').addClass('alert-danger');
                                $('#errors_code').text(data.product_code).fadeIn();
                            }
                            else{
                                $('#code').removeClass('alert-danger');
                                $('#errors_code').fadeOut();
                            }

                            if(data.product_price_from!=''){
                                $('#price_from').addClass('alert-danger');
                                $('#errors_price_from').text(data.product_price_from).fadeIn();
                            }
                            else{
                                $('#price_from').removeClass('alert-danger');
                                $('#errors_price_from').fadeOut();
                            }

                            if(data.product_price_to!=''){
                                $('#price_to').addClass('alert-danger');
                                $('#errors_price_to').text(data.product_price_to).fadeIn();
                            }
                            else{
                                $('#price_to').removeClass('alert-danger');
                                $('#errors_price_to').fadeOut();
                            }
                            $('#status_message').addClass('alert '+data.status_class).fadeIn();
                            $('html, body').animate({
                                scrollTop: $('#status_message').offset().top-100
                            }, 500);
                        }

                        else
                        {
                            $('#status_message').text(data.status_message).addClass('alert '+data.status_class).fadeIn();
                            $('html, body').animate({
                                scrollTop: $('#status_message').offset().top-135
                            }, 500);
                        }
                    },
                    error: function () {
                        alert("Bad request ! Please try again.")
                    }
                });
            });
        });
    </script>

    <script>
        $('#za_nas').click(function(){
            window.location.href ='{!! route('getHome') !!}#about-us';
        });
    </script>

@endsection
