@extends('layout')
@section('styles')
    <link rel="stylesheet" href="{!! URL::asset('css/admin.css') !!}">
    <link href="{!! URL::asset('css/jquery.Jcrop.min.css') !!}" rel="stylesheet">
    <script src="{!! URL::asset('js/jquery.min.js') !!}"></script>
    <style>
        body{
            background: #373737;
        }
        .panel-body{
            background: #3a3a3a;
        }
        select{
            background: rgb(73, 73, 73) !important;
            color: #fff!important;
        }

        .img-container{
            width:100%;
            height:auto;
        }
    </style>
@endsection
@section('content')
    <div class="container top-margin">
        <div class="row">
            <div class="col-md-12">
                <div class="panel panel-primary top-panel-margin">
                    <div class="panel-heading">
                        <span class="fa fa-crop"></span>
                        Едитирај слика

                        <a href="{!! route('getEditGallery', ['id'=>session('gallery_id')]) !!}" class="btn btn-sm btn-primary" style="float:right">
                            <span class="fa fa-arrow-left"></span>
                            Галерија
                        </a>
                    </div>
                    <div class="panel-body">
                        @if(session('status'))
                            <div class="alert {!! session('status-class') !!} alert-dismissable fade in">
                                <a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>
                                {!! session('status') !!}
                            </div>
                        @endif
                        <div class="col-md-12">
                            <select name="crop_select" id="crop_select" class="form-control">
                                <option value="image">Crop Image</option>
                                <option value="thumbnail">Crop Image thumbnail</option>
                            </select>
                            <br>
                        </div>
                        <div class="col-md-12">
                            <div class="crop-img" id="img-container">
                                <img src="{!! URL::asset('images/galleries/'.session('gallery_id').'/'.session('image'))!!}?nocache={!! str_random(5) !!}" id="cropimage">
                            </div>
                            <form method="post" action="{!! route('postCropImage', ['id'=>session('image_id')]) !!}"  id="crop_form">
                            {!! csrf_field() !!}
                            <?= \Form::hidden('image', session('image')) ?>
                            <?= \Form::hidden('x', '', array('id' => 'x')) ?>
                            <?= \Form::hidden('y', '', array('id' => 'y')) ?>
                            <?= \Form::hidden('w', '', array('id' => 'w')) ?>
                            <?= \Form::hidden('h', '', array('id' => 'h')) ?>
                            <div class="form-group" style="margin-top: 10px;">
                                <button type="submit" class="btn btn-success">
                                    ЗАЧУВАЈ
                                    <i class="fa fa-save" aria-hidden="true"></i>
                                </button>
                            </div>
                            </form>
                            <script type="text/javascript">
                                $(function() {
                                    var img = document.getElementById('img-container');
                                    var width = img.clientWidth;
                                    var height = 'auto';

                                    $('#crop_select').on('change', function (e) {
                                        if($('#crop_select').val()=='image')
                                        {
                                            document.getElementById("crop_form").action = '{!! route('postCropImage', ['id'=>session('image_id')]) !!}';
                                            $('#cropimage').Jcrop({
                                                aspectRatio:'',
                                                onSelect: updateCoords,
                                                boxWidth: width,
                                                boxHeight: height
                                            });
                                        }
                                        if($('#crop_select').val()=='thumbnail')
                                        {
                                            document.getElementById("crop_form").action = '{!! route('postCropThumbnail', ['id'=>session('image_id')]) !!}';
                                            $('#cropimage').Jcrop({
                                                aspectRatio:1,
                                                onSelect: updateCoords,
                                                boxWidth: width,
                                                boxHeight: height
                                            });
                                        }
                                    });

                                    $('#cropimage').Jcrop({
                                        aspectRatio:'',
                                        onSelect: updateCoords,
                                        boxWidth: width,
                                        boxHeight: height
                                    });
                                });
                                function updateCoords(c) {
                                    $('#x').val(c.x);
                                    $('#y').val(c.y);
                                    $('#w').val(c.w);
                                    $('#h').val(c.h);
                                }
                            </script>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('scripts')
    <script src="{!! URL::asset('js/jquery.Jcrop.min.js') !!}"></script>
    <script>
        $('#za_nas').click(function(){
            window.location.href ='{!! route('getHome') !!}#about-us';
        });
    </script>
@endsection
